/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.BridgeSource;

@SdkInternalApi
public class BridgeSourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> FLOWSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("flowSource").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkSource").build();
    private static final BridgeSourceMarshaller instance = new BridgeSourceMarshaller();

    public static BridgeSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(BridgeSource bridgeSource, ProtocolMarshaller protocolMarshaller) {
        if (bridgeSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)bridgeSource.getFlowSource(), FLOWSOURCE_BINDING);
            protocolMarshaller.marshall((Object)bridgeSource.getNetworkSource(), NETWORKSOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

