/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.DestinationConfigurationRequest;
import com.amazonaws.services.mediaconnect.model.EncodingName;
import com.amazonaws.services.mediaconnect.model.EncodingParametersRequest;
import com.amazonaws.services.mediaconnect.model.transform.MediaStreamOutputConfigurationRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MediaStreamOutputConfigurationRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DestinationConfigurationRequest> destinationConfigurations;
    private String encodingName;
    private EncodingParametersRequest encodingParameters;
    private String mediaStreamName;

    public List<DestinationConfigurationRequest> getDestinationConfigurations() {
        return this.destinationConfigurations;
    }

    public void setDestinationConfigurations(Collection<DestinationConfigurationRequest> destinationConfigurations) {
        if (destinationConfigurations == null) {
            this.destinationConfigurations = null;
            return;
        }
        this.destinationConfigurations = new ArrayList<DestinationConfigurationRequest>(destinationConfigurations);
    }

    public MediaStreamOutputConfigurationRequest withDestinationConfigurations(DestinationConfigurationRequest ... destinationConfigurations) {
        if (this.destinationConfigurations == null) {
            this.setDestinationConfigurations(new ArrayList<DestinationConfigurationRequest>(destinationConfigurations.length));
        }
        for (DestinationConfigurationRequest ele : destinationConfigurations) {
            this.destinationConfigurations.add(ele);
        }
        return this;
    }

    public MediaStreamOutputConfigurationRequest withDestinationConfigurations(Collection<DestinationConfigurationRequest> destinationConfigurations) {
        this.setDestinationConfigurations(destinationConfigurations);
        return this;
    }

    public void setEncodingName(String encodingName) {
        this.encodingName = encodingName;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public MediaStreamOutputConfigurationRequest withEncodingName(String encodingName) {
        this.setEncodingName(encodingName);
        return this;
    }

    public MediaStreamOutputConfigurationRequest withEncodingName(EncodingName encodingName) {
        this.encodingName = encodingName.toString();
        return this;
    }

    public void setEncodingParameters(EncodingParametersRequest encodingParameters) {
        this.encodingParameters = encodingParameters;
    }

    public EncodingParametersRequest getEncodingParameters() {
        return this.encodingParameters;
    }

    public MediaStreamOutputConfigurationRequest withEncodingParameters(EncodingParametersRequest encodingParameters) {
        this.setEncodingParameters(encodingParameters);
        return this;
    }

    public void setMediaStreamName(String mediaStreamName) {
        this.mediaStreamName = mediaStreamName;
    }

    public String getMediaStreamName() {
        return this.mediaStreamName;
    }

    public MediaStreamOutputConfigurationRequest withMediaStreamName(String mediaStreamName) {
        this.setMediaStreamName(mediaStreamName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinationConfigurations() != null) {
            sb.append("DestinationConfigurations: ").append(this.getDestinationConfigurations()).append(",");
        }
        if (this.getEncodingName() != null) {
            sb.append("EncodingName: ").append(this.getEncodingName()).append(",");
        }
        if (this.getEncodingParameters() != null) {
            sb.append("EncodingParameters: ").append(this.getEncodingParameters()).append(",");
        }
        if (this.getMediaStreamName() != null) {
            sb.append("MediaStreamName: ").append(this.getMediaStreamName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamOutputConfigurationRequest)) {
            return false;
        }
        MediaStreamOutputConfigurationRequest other = (MediaStreamOutputConfigurationRequest)obj;
        if (other.getDestinationConfigurations() == null ^ this.getDestinationConfigurations() == null) {
            return false;
        }
        if (other.getDestinationConfigurations() != null && !other.getDestinationConfigurations().equals(this.getDestinationConfigurations())) {
            return false;
        }
        if (other.getEncodingName() == null ^ this.getEncodingName() == null) {
            return false;
        }
        if (other.getEncodingName() != null && !other.getEncodingName().equals(this.getEncodingName())) {
            return false;
        }
        if (other.getEncodingParameters() == null ^ this.getEncodingParameters() == null) {
            return false;
        }
        if (other.getEncodingParameters() != null && !other.getEncodingParameters().equals(this.getEncodingParameters())) {
            return false;
        }
        if (other.getMediaStreamName() == null ^ this.getMediaStreamName() == null) {
            return false;
        }
        return other.getMediaStreamName() == null || other.getMediaStreamName().equals(this.getMediaStreamName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinationConfigurations() == null ? 0 : this.getDestinationConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getEncodingName() == null ? 0 : this.getEncodingName().hashCode());
        hashCode = 31 * hashCode + (this.getEncodingParameters() == null ? 0 : this.getEncodingParameters().hashCode());
        hashCode = 31 * hashCode + (this.getMediaStreamName() == null ? 0 : this.getMediaStreamName().hashCode());
        return hashCode;
    }

    public MediaStreamOutputConfigurationRequest clone() {
        try {
            return (MediaStreamOutputConfigurationRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MediaStreamOutputConfigurationRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

