/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.Encryption;
import com.amazonaws.services.mediaconnect.model.transform.EntitlementMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Entitlement
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer dataTransferSubscriberFeePercent;
    private String description;
    private Encryption encryption;
    private String entitlementArn;
    private String name;
    private List<String> subscribers;

    public void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
        this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
    }

    public Integer getDataTransferSubscriberFeePercent() {
        return this.dataTransferSubscriberFeePercent;
    }

    public Entitlement withDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
        this.setDataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Entitlement withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public Entitlement withEncryption(Encryption encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public void setEntitlementArn(String entitlementArn) {
        this.entitlementArn = entitlementArn;
    }

    public String getEntitlementArn() {
        return this.entitlementArn;
    }

    public Entitlement withEntitlementArn(String entitlementArn) {
        this.setEntitlementArn(entitlementArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Entitlement withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getSubscribers() {
        return this.subscribers;
    }

    public void setSubscribers(Collection<String> subscribers) {
        if (subscribers == null) {
            this.subscribers = null;
            return;
        }
        this.subscribers = new ArrayList<String>(subscribers);
    }

    public Entitlement withSubscribers(String ... subscribers) {
        if (this.subscribers == null) {
            this.setSubscribers(new ArrayList<String>(subscribers.length));
        }
        for (String ele : subscribers) {
            this.subscribers.add(ele);
        }
        return this;
    }

    public Entitlement withSubscribers(Collection<String> subscribers) {
        this.setSubscribers(subscribers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataTransferSubscriberFeePercent() != null) {
            sb.append("DataTransferSubscriberFeePercent: ").append(this.getDataTransferSubscriberFeePercent()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getEntitlementArn() != null) {
            sb.append("EntitlementArn: ").append(this.getEntitlementArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSubscribers() != null) {
            sb.append("Subscribers: ").append(this.getSubscribers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement)obj;
        if (other.getDataTransferSubscriberFeePercent() == null ^ this.getDataTransferSubscriberFeePercent() == null) {
            return false;
        }
        if (other.getDataTransferSubscriberFeePercent() != null && !other.getDataTransferSubscriberFeePercent().equals(this.getDataTransferSubscriberFeePercent())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getEntitlementArn() == null ^ this.getEntitlementArn() == null) {
            return false;
        }
        if (other.getEntitlementArn() != null && !other.getEntitlementArn().equals(this.getEntitlementArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSubscribers() == null ^ this.getSubscribers() == null) {
            return false;
        }
        return other.getSubscribers() == null || other.getSubscribers().equals(this.getSubscribers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataTransferSubscriberFeePercent() == null ? 0 : this.getDataTransferSubscriberFeePercent().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getEntitlementArn() == null ? 0 : this.getEntitlementArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSubscribers() == null ? 0 : this.getSubscribers().hashCode());
        return hashCode;
    }

    public Entitlement clone() {
        try {
            return (Entitlement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntitlementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

