/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediaconnect.AWSMediaConnectAsync;
import com.amazonaws.services.mediaconnect.AWSMediaConnectAsyncClientBuilder;
import com.amazonaws.services.mediaconnect.AWSMediaConnectClient;
import com.amazonaws.services.mediaconnect.model.AddFlowOutputsRequest;
import com.amazonaws.services.mediaconnect.model.AddFlowOutputsResult;
import com.amazonaws.services.mediaconnect.model.CreateFlowRequest;
import com.amazonaws.services.mediaconnect.model.CreateFlowResult;
import com.amazonaws.services.mediaconnect.model.DeleteFlowRequest;
import com.amazonaws.services.mediaconnect.model.DeleteFlowResult;
import com.amazonaws.services.mediaconnect.model.DescribeFlowRequest;
import com.amazonaws.services.mediaconnect.model.DescribeFlowResult;
import com.amazonaws.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import com.amazonaws.services.mediaconnect.model.GrantFlowEntitlementsResult;
import com.amazonaws.services.mediaconnect.model.ListEntitlementsRequest;
import com.amazonaws.services.mediaconnect.model.ListEntitlementsResult;
import com.amazonaws.services.mediaconnect.model.ListFlowsRequest;
import com.amazonaws.services.mediaconnect.model.ListFlowsResult;
import com.amazonaws.services.mediaconnect.model.RemoveFlowOutputRequest;
import com.amazonaws.services.mediaconnect.model.RemoveFlowOutputResult;
import com.amazonaws.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import com.amazonaws.services.mediaconnect.model.RevokeFlowEntitlementResult;
import com.amazonaws.services.mediaconnect.model.StartFlowRequest;
import com.amazonaws.services.mediaconnect.model.StartFlowResult;
import com.amazonaws.services.mediaconnect.model.StopFlowRequest;
import com.amazonaws.services.mediaconnect.model.StopFlowResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowEntitlementResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowOutputRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowOutputResult;
import com.amazonaws.services.mediaconnect.model.UpdateFlowSourceRequest;
import com.amazonaws.services.mediaconnect.model.UpdateFlowSourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaConnectAsyncClient
extends AWSMediaConnectClient
implements AWSMediaConnectAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaConnectAsyncClientBuilder asyncBuilder() {
        return AWSMediaConnectAsyncClientBuilder.standard();
    }

    AWSMediaConnectAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddFlowOutputsResult> addFlowOutputsAsync(AddFlowOutputsRequest request) {
        return this.addFlowOutputsAsync(request, null);
    }

    @Override
    public Future<AddFlowOutputsResult> addFlowOutputsAsync(AddFlowOutputsRequest request, final AsyncHandler<AddFlowOutputsRequest, AddFlowOutputsResult> asyncHandler) {
        final AddFlowOutputsRequest finalRequest = (AddFlowOutputsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddFlowOutputsResult>(){

            @Override
            public AddFlowOutputsResult call() throws Exception {
                AddFlowOutputsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeAddFlowOutputs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFlowResult> createFlowAsync(CreateFlowRequest request) {
        return this.createFlowAsync(request, null);
    }

    @Override
    public Future<CreateFlowResult> createFlowAsync(CreateFlowRequest request, final AsyncHandler<CreateFlowRequest, CreateFlowResult> asyncHandler) {
        final CreateFlowRequest finalRequest = (CreateFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFlowResult>(){

            @Override
            public CreateFlowResult call() throws Exception {
                CreateFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeCreateFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFlowResult> deleteFlowAsync(DeleteFlowRequest request) {
        return this.deleteFlowAsync(request, null);
    }

    @Override
    public Future<DeleteFlowResult> deleteFlowAsync(DeleteFlowRequest request, final AsyncHandler<DeleteFlowRequest, DeleteFlowResult> asyncHandler) {
        final DeleteFlowRequest finalRequest = (DeleteFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFlowResult>(){

            @Override
            public DeleteFlowResult call() throws Exception {
                DeleteFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDeleteFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFlowResult> describeFlowAsync(DescribeFlowRequest request) {
        return this.describeFlowAsync(request, null);
    }

    @Override
    public Future<DescribeFlowResult> describeFlowAsync(DescribeFlowRequest request, final AsyncHandler<DescribeFlowRequest, DescribeFlowResult> asyncHandler) {
        final DescribeFlowRequest finalRequest = (DescribeFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFlowResult>(){

            @Override
            public DescribeFlowResult call() throws Exception {
                DescribeFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeDescribeFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GrantFlowEntitlementsResult> grantFlowEntitlementsAsync(GrantFlowEntitlementsRequest request) {
        return this.grantFlowEntitlementsAsync(request, null);
    }

    @Override
    public Future<GrantFlowEntitlementsResult> grantFlowEntitlementsAsync(GrantFlowEntitlementsRequest request, final AsyncHandler<GrantFlowEntitlementsRequest, GrantFlowEntitlementsResult> asyncHandler) {
        final GrantFlowEntitlementsRequest finalRequest = (GrantFlowEntitlementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GrantFlowEntitlementsResult>(){

            @Override
            public GrantFlowEntitlementsResult call() throws Exception {
                GrantFlowEntitlementsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeGrantFlowEntitlements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEntitlementsResult> listEntitlementsAsync(ListEntitlementsRequest request) {
        return this.listEntitlementsAsync(request, null);
    }

    @Override
    public Future<ListEntitlementsResult> listEntitlementsAsync(ListEntitlementsRequest request, final AsyncHandler<ListEntitlementsRequest, ListEntitlementsResult> asyncHandler) {
        final ListEntitlementsRequest finalRequest = (ListEntitlementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEntitlementsResult>(){

            @Override
            public ListEntitlementsResult call() throws Exception {
                ListEntitlementsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListEntitlements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFlowsResult> listFlowsAsync(ListFlowsRequest request) {
        return this.listFlowsAsync(request, null);
    }

    @Override
    public Future<ListFlowsResult> listFlowsAsync(ListFlowsRequest request, final AsyncHandler<ListFlowsRequest, ListFlowsResult> asyncHandler) {
        final ListFlowsRequest finalRequest = (ListFlowsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFlowsResult>(){

            @Override
            public ListFlowsResult call() throws Exception {
                ListFlowsResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeListFlows(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveFlowOutputResult> removeFlowOutputAsync(RemoveFlowOutputRequest request) {
        return this.removeFlowOutputAsync(request, null);
    }

    @Override
    public Future<RemoveFlowOutputResult> removeFlowOutputAsync(RemoveFlowOutputRequest request, final AsyncHandler<RemoveFlowOutputRequest, RemoveFlowOutputResult> asyncHandler) {
        final RemoveFlowOutputRequest finalRequest = (RemoveFlowOutputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveFlowOutputResult>(){

            @Override
            public RemoveFlowOutputResult call() throws Exception {
                RemoveFlowOutputResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRemoveFlowOutput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokeFlowEntitlementResult> revokeFlowEntitlementAsync(RevokeFlowEntitlementRequest request) {
        return this.revokeFlowEntitlementAsync(request, null);
    }

    @Override
    public Future<RevokeFlowEntitlementResult> revokeFlowEntitlementAsync(RevokeFlowEntitlementRequest request, final AsyncHandler<RevokeFlowEntitlementRequest, RevokeFlowEntitlementResult> asyncHandler) {
        final RevokeFlowEntitlementRequest finalRequest = (RevokeFlowEntitlementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokeFlowEntitlementResult>(){

            @Override
            public RevokeFlowEntitlementResult call() throws Exception {
                RevokeFlowEntitlementResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeRevokeFlowEntitlement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFlowResult> startFlowAsync(StartFlowRequest request) {
        return this.startFlowAsync(request, null);
    }

    @Override
    public Future<StartFlowResult> startFlowAsync(StartFlowRequest request, final AsyncHandler<StartFlowRequest, StartFlowResult> asyncHandler) {
        final StartFlowRequest finalRequest = (StartFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFlowResult>(){

            @Override
            public StartFlowResult call() throws Exception {
                StartFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeStartFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopFlowResult> stopFlowAsync(StopFlowRequest request) {
        return this.stopFlowAsync(request, null);
    }

    @Override
    public Future<StopFlowResult> stopFlowAsync(StopFlowRequest request, final AsyncHandler<StopFlowRequest, StopFlowResult> asyncHandler) {
        final StopFlowRequest finalRequest = (StopFlowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopFlowResult>(){

            @Override
            public StopFlowResult call() throws Exception {
                StopFlowResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeStopFlow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowEntitlementResult> updateFlowEntitlementAsync(UpdateFlowEntitlementRequest request) {
        return this.updateFlowEntitlementAsync(request, null);
    }

    @Override
    public Future<UpdateFlowEntitlementResult> updateFlowEntitlementAsync(UpdateFlowEntitlementRequest request, final AsyncHandler<UpdateFlowEntitlementRequest, UpdateFlowEntitlementResult> asyncHandler) {
        final UpdateFlowEntitlementRequest finalRequest = (UpdateFlowEntitlementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowEntitlementResult>(){

            @Override
            public UpdateFlowEntitlementResult call() throws Exception {
                UpdateFlowEntitlementResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowEntitlement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowOutputResult> updateFlowOutputAsync(UpdateFlowOutputRequest request) {
        return this.updateFlowOutputAsync(request, null);
    }

    @Override
    public Future<UpdateFlowOutputResult> updateFlowOutputAsync(UpdateFlowOutputRequest request, final AsyncHandler<UpdateFlowOutputRequest, UpdateFlowOutputResult> asyncHandler) {
        final UpdateFlowOutputRequest finalRequest = (UpdateFlowOutputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowOutputResult>(){

            @Override
            public UpdateFlowOutputResult call() throws Exception {
                UpdateFlowOutputResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowOutput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowSourceResult> updateFlowSourceAsync(UpdateFlowSourceRequest request) {
        return this.updateFlowSourceAsync(request, null);
    }

    @Override
    public Future<UpdateFlowSourceResult> updateFlowSourceAsync(UpdateFlowSourceRequest request, final AsyncHandler<UpdateFlowSourceRequest, UpdateFlowSourceResult> asyncHandler) {
        final UpdateFlowSourceRequest finalRequest = (UpdateFlowSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowSourceResult>(){

            @Override
            public UpdateFlowSourceResult call() throws Exception {
                UpdateFlowSourceResult result = null;
                try {
                    result = AWSMediaConnectAsyncClient.this.executeUpdateFlowSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

