/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.marketplacemetering.model.UsageRecord;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class UsageRecordMarshaller {
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CUSTOMERIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomerIdentifier").build();
    private static final MarshallingInfo<String> DIMENSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimension").build();
    private static final MarshallingInfo<Integer> QUANTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Quantity").build();
    private static final MarshallingInfo<List> USAGEALLOCATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UsageAllocations").build();
    private static final UsageRecordMarshaller instance = new UsageRecordMarshaller();

    public static UsageRecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(UsageRecord usageRecord, ProtocolMarshaller protocolMarshaller) {
        if (usageRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)usageRecord.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)usageRecord.getCustomerIdentifier(), CUSTOMERIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)usageRecord.getDimension(), DIMENSION_BINDING);
            protocolMarshaller.marshall((Object)usageRecord.getQuantity(), QUANTITY_BINDING);
            protocolMarshaller.marshall(usageRecord.getUsageAllocations(), USAGEALLOCATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

