/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedgrafana.model.AccountAccessType;
import com.amazonaws.services.managedgrafana.model.AuthenticationSummary;
import com.amazonaws.services.managedgrafana.model.DataSourceType;
import com.amazonaws.services.managedgrafana.model.LicenseType;
import com.amazonaws.services.managedgrafana.model.NotificationDestinationType;
import com.amazonaws.services.managedgrafana.model.PermissionType;
import com.amazonaws.services.managedgrafana.model.VpcConfiguration;
import com.amazonaws.services.managedgrafana.model.WorkspaceStatus;
import com.amazonaws.services.managedgrafana.model.transform.WorkspaceDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkspaceDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountAccessType;
    private AuthenticationSummary authentication;
    private Date created;
    private List<String> dataSources;
    private String description;
    private String endpoint;
    private Boolean freeTrialConsumed;
    private Date freeTrialExpiration;
    private String grafanaVersion;
    private String id;
    private Date licenseExpiration;
    private String licenseType;
    private Date modified;
    private String name;
    private List<String> notificationDestinations;
    private String organizationRoleName;
    private List<String> organizationalUnits;
    private String permissionType;
    private String stackSetName;
    private String status;
    private Map<String, String> tags;
    private VpcConfiguration vpcConfiguration;
    private String workspaceRoleArn;

    public void setAccountAccessType(String accountAccessType) {
        this.accountAccessType = accountAccessType;
    }

    public String getAccountAccessType() {
        return this.accountAccessType;
    }

    public WorkspaceDescription withAccountAccessType(String accountAccessType) {
        this.setAccountAccessType(accountAccessType);
        return this;
    }

    public WorkspaceDescription withAccountAccessType(AccountAccessType accountAccessType) {
        this.accountAccessType = accountAccessType.toString();
        return this;
    }

    public void setAuthentication(AuthenticationSummary authentication) {
        this.authentication = authentication;
    }

    public AuthenticationSummary getAuthentication() {
        return this.authentication;
    }

    public WorkspaceDescription withAuthentication(AuthenticationSummary authentication) {
        this.setAuthentication(authentication);
        return this;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public WorkspaceDescription withCreated(Date created) {
        this.setCreated(created);
        return this;
    }

    public List<String> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(Collection<String> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
            return;
        }
        this.dataSources = new ArrayList<String>(dataSources);
    }

    public WorkspaceDescription withDataSources(String ... dataSources) {
        if (this.dataSources == null) {
            this.setDataSources(new ArrayList<String>(dataSources.length));
        }
        for (String ele : dataSources) {
            this.dataSources.add(ele);
        }
        return this;
    }

    public WorkspaceDescription withDataSources(Collection<String> dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    public WorkspaceDescription withDataSources(DataSourceType ... dataSources) {
        ArrayList<String> dataSourcesCopy = new ArrayList<String>(dataSources.length);
        for (DataSourceType value : dataSources) {
            dataSourcesCopy.add(value.toString());
        }
        if (this.getDataSources() == null) {
            this.setDataSources(dataSourcesCopy);
        } else {
            this.getDataSources().addAll(dataSourcesCopy);
        }
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public WorkspaceDescription withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public WorkspaceDescription withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setFreeTrialConsumed(Boolean freeTrialConsumed) {
        this.freeTrialConsumed = freeTrialConsumed;
    }

    public Boolean getFreeTrialConsumed() {
        return this.freeTrialConsumed;
    }

    public WorkspaceDescription withFreeTrialConsumed(Boolean freeTrialConsumed) {
        this.setFreeTrialConsumed(freeTrialConsumed);
        return this;
    }

    public Boolean isFreeTrialConsumed() {
        return this.freeTrialConsumed;
    }

    public void setFreeTrialExpiration(Date freeTrialExpiration) {
        this.freeTrialExpiration = freeTrialExpiration;
    }

    public Date getFreeTrialExpiration() {
        return this.freeTrialExpiration;
    }

    public WorkspaceDescription withFreeTrialExpiration(Date freeTrialExpiration) {
        this.setFreeTrialExpiration(freeTrialExpiration);
        return this;
    }

    public void setGrafanaVersion(String grafanaVersion) {
        this.grafanaVersion = grafanaVersion;
    }

    public String getGrafanaVersion() {
        return this.grafanaVersion;
    }

    public WorkspaceDescription withGrafanaVersion(String grafanaVersion) {
        this.setGrafanaVersion(grafanaVersion);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public WorkspaceDescription withId(String id) {
        this.setId(id);
        return this;
    }

    public void setLicenseExpiration(Date licenseExpiration) {
        this.licenseExpiration = licenseExpiration;
    }

    public Date getLicenseExpiration() {
        return this.licenseExpiration;
    }

    public WorkspaceDescription withLicenseExpiration(Date licenseExpiration) {
        this.setLicenseExpiration(licenseExpiration);
        return this;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public WorkspaceDescription withLicenseType(String licenseType) {
        this.setLicenseType(licenseType);
        return this;
    }

    public WorkspaceDescription withLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType.toString();
        return this;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getModified() {
        return this.modified;
    }

    public WorkspaceDescription withModified(Date modified) {
        this.setModified(modified);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public WorkspaceDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getNotificationDestinations() {
        return this.notificationDestinations;
    }

    public void setNotificationDestinations(Collection<String> notificationDestinations) {
        if (notificationDestinations == null) {
            this.notificationDestinations = null;
            return;
        }
        this.notificationDestinations = new ArrayList<String>(notificationDestinations);
    }

    public WorkspaceDescription withNotificationDestinations(String ... notificationDestinations) {
        if (this.notificationDestinations == null) {
            this.setNotificationDestinations(new ArrayList<String>(notificationDestinations.length));
        }
        for (String ele : notificationDestinations) {
            this.notificationDestinations.add(ele);
        }
        return this;
    }

    public WorkspaceDescription withNotificationDestinations(Collection<String> notificationDestinations) {
        this.setNotificationDestinations(notificationDestinations);
        return this;
    }

    public WorkspaceDescription withNotificationDestinations(NotificationDestinationType ... notificationDestinations) {
        ArrayList<String> notificationDestinationsCopy = new ArrayList<String>(notificationDestinations.length);
        for (NotificationDestinationType value : notificationDestinations) {
            notificationDestinationsCopy.add(value.toString());
        }
        if (this.getNotificationDestinations() == null) {
            this.setNotificationDestinations(notificationDestinationsCopy);
        } else {
            this.getNotificationDestinations().addAll(notificationDestinationsCopy);
        }
        return this;
    }

    public void setOrganizationRoleName(String organizationRoleName) {
        this.organizationRoleName = organizationRoleName;
    }

    public String getOrganizationRoleName() {
        return this.organizationRoleName;
    }

    public WorkspaceDescription withOrganizationRoleName(String organizationRoleName) {
        this.setOrganizationRoleName(organizationRoleName);
        return this;
    }

    public List<String> getOrganizationalUnits() {
        return this.organizationalUnits;
    }

    public void setOrganizationalUnits(Collection<String> organizationalUnits) {
        if (organizationalUnits == null) {
            this.organizationalUnits = null;
            return;
        }
        this.organizationalUnits = new ArrayList<String>(organizationalUnits);
    }

    public WorkspaceDescription withOrganizationalUnits(String ... organizationalUnits) {
        if (this.organizationalUnits == null) {
            this.setOrganizationalUnits(new ArrayList<String>(organizationalUnits.length));
        }
        for (String ele : organizationalUnits) {
            this.organizationalUnits.add(ele);
        }
        return this;
    }

    public WorkspaceDescription withOrganizationalUnits(Collection<String> organizationalUnits) {
        this.setOrganizationalUnits(organizationalUnits);
        return this;
    }

    public void setPermissionType(String permissionType) {
        this.permissionType = permissionType;
    }

    public String getPermissionType() {
        return this.permissionType;
    }

    public WorkspaceDescription withPermissionType(String permissionType) {
        this.setPermissionType(permissionType);
        return this;
    }

    public WorkspaceDescription withPermissionType(PermissionType permissionType) {
        this.permissionType = permissionType.toString();
        return this;
    }

    public void setStackSetName(String stackSetName) {
        this.stackSetName = stackSetName;
    }

    public String getStackSetName() {
        return this.stackSetName;
    }

    public WorkspaceDescription withStackSetName(String stackSetName) {
        this.setStackSetName(stackSetName);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public WorkspaceDescription withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public WorkspaceDescription withStatus(WorkspaceStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public WorkspaceDescription withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public WorkspaceDescription addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public WorkspaceDescription clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setVpcConfiguration(VpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public VpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public WorkspaceDescription withVpcConfiguration(VpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public void setWorkspaceRoleArn(String workspaceRoleArn) {
        this.workspaceRoleArn = workspaceRoleArn;
    }

    public String getWorkspaceRoleArn() {
        return this.workspaceRoleArn;
    }

    public WorkspaceDescription withWorkspaceRoleArn(String workspaceRoleArn) {
        this.setWorkspaceRoleArn(workspaceRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountAccessType() != null) {
            sb.append("AccountAccessType: ").append(this.getAccountAccessType()).append(",");
        }
        if (this.getAuthentication() != null) {
            sb.append("Authentication: ").append(this.getAuthentication()).append(",");
        }
        if (this.getCreated() != null) {
            sb.append("Created: ").append(this.getCreated()).append(",");
        }
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getFreeTrialConsumed() != null) {
            sb.append("FreeTrialConsumed: ").append(this.getFreeTrialConsumed()).append(",");
        }
        if (this.getFreeTrialExpiration() != null) {
            sb.append("FreeTrialExpiration: ").append(this.getFreeTrialExpiration()).append(",");
        }
        if (this.getGrafanaVersion() != null) {
            sb.append("GrafanaVersion: ").append(this.getGrafanaVersion()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getLicenseExpiration() != null) {
            sb.append("LicenseExpiration: ").append(this.getLicenseExpiration()).append(",");
        }
        if (this.getLicenseType() != null) {
            sb.append("LicenseType: ").append(this.getLicenseType()).append(",");
        }
        if (this.getModified() != null) {
            sb.append("Modified: ").append(this.getModified()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getNotificationDestinations() != null) {
            sb.append("NotificationDestinations: ").append(this.getNotificationDestinations()).append(",");
        }
        if (this.getOrganizationRoleName() != null) {
            sb.append("OrganizationRoleName: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOrganizationalUnits() != null) {
            sb.append("OrganizationalUnits: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPermissionType() != null) {
            sb.append("PermissionType: ").append(this.getPermissionType()).append(",");
        }
        if (this.getStackSetName() != null) {
            sb.append("StackSetName: ").append(this.getStackSetName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration()).append(",");
        }
        if (this.getWorkspaceRoleArn() != null) {
            sb.append("WorkspaceRoleArn: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceDescription)) {
            return false;
        }
        WorkspaceDescription other = (WorkspaceDescription)obj;
        if (other.getAccountAccessType() == null ^ this.getAccountAccessType() == null) {
            return false;
        }
        if (other.getAccountAccessType() != null && !other.getAccountAccessType().equals(this.getAccountAccessType())) {
            return false;
        }
        if (other.getAuthentication() == null ^ this.getAuthentication() == null) {
            return false;
        }
        if (other.getAuthentication() != null && !other.getAuthentication().equals(this.getAuthentication())) {
            return false;
        }
        if (other.getCreated() == null ^ this.getCreated() == null) {
            return false;
        }
        if (other.getCreated() != null && !other.getCreated().equals(this.getCreated())) {
            return false;
        }
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getFreeTrialConsumed() == null ^ this.getFreeTrialConsumed() == null) {
            return false;
        }
        if (other.getFreeTrialConsumed() != null && !other.getFreeTrialConsumed().equals(this.getFreeTrialConsumed())) {
            return false;
        }
        if (other.getFreeTrialExpiration() == null ^ this.getFreeTrialExpiration() == null) {
            return false;
        }
        if (other.getFreeTrialExpiration() != null && !other.getFreeTrialExpiration().equals(this.getFreeTrialExpiration())) {
            return false;
        }
        if (other.getGrafanaVersion() == null ^ this.getGrafanaVersion() == null) {
            return false;
        }
        if (other.getGrafanaVersion() != null && !other.getGrafanaVersion().equals(this.getGrafanaVersion())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getLicenseExpiration() == null ^ this.getLicenseExpiration() == null) {
            return false;
        }
        if (other.getLicenseExpiration() != null && !other.getLicenseExpiration().equals(this.getLicenseExpiration())) {
            return false;
        }
        if (other.getLicenseType() == null ^ this.getLicenseType() == null) {
            return false;
        }
        if (other.getLicenseType() != null && !other.getLicenseType().equals(this.getLicenseType())) {
            return false;
        }
        if (other.getModified() == null ^ this.getModified() == null) {
            return false;
        }
        if (other.getModified() != null && !other.getModified().equals(this.getModified())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getNotificationDestinations() == null ^ this.getNotificationDestinations() == null) {
            return false;
        }
        if (other.getNotificationDestinations() != null && !other.getNotificationDestinations().equals(this.getNotificationDestinations())) {
            return false;
        }
        if (other.getOrganizationRoleName() == null ^ this.getOrganizationRoleName() == null) {
            return false;
        }
        if (other.getOrganizationRoleName() != null && !other.getOrganizationRoleName().equals(this.getOrganizationRoleName())) {
            return false;
        }
        if (other.getOrganizationalUnits() == null ^ this.getOrganizationalUnits() == null) {
            return false;
        }
        if (other.getOrganizationalUnits() != null && !other.getOrganizationalUnits().equals(this.getOrganizationalUnits())) {
            return false;
        }
        if (other.getPermissionType() == null ^ this.getPermissionType() == null) {
            return false;
        }
        if (other.getPermissionType() != null && !other.getPermissionType().equals(this.getPermissionType())) {
            return false;
        }
        if (other.getStackSetName() == null ^ this.getStackSetName() == null) {
            return false;
        }
        if (other.getStackSetName() != null && !other.getStackSetName().equals(this.getStackSetName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        if (other.getVpcConfiguration() != null && !other.getVpcConfiguration().equals(this.getVpcConfiguration())) {
            return false;
        }
        if (other.getWorkspaceRoleArn() == null ^ this.getWorkspaceRoleArn() == null) {
            return false;
        }
        return other.getWorkspaceRoleArn() == null || other.getWorkspaceRoleArn().equals(this.getWorkspaceRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountAccessType() == null ? 0 : this.getAccountAccessType().hashCode());
        hashCode = 31 * hashCode + (this.getAuthentication() == null ? 0 : this.getAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.getCreated() == null ? 0 : this.getCreated().hashCode());
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getFreeTrialConsumed() == null ? 0 : this.getFreeTrialConsumed().hashCode());
        hashCode = 31 * hashCode + (this.getFreeTrialExpiration() == null ? 0 : this.getFreeTrialExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getGrafanaVersion() == null ? 0 : this.getGrafanaVersion().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseExpiration() == null ? 0 : this.getLicenseExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseType() == null ? 0 : this.getLicenseType().hashCode());
        hashCode = 31 * hashCode + (this.getModified() == null ? 0 : this.getModified().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationDestinations() == null ? 0 : this.getNotificationDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationRoleName() == null ? 0 : this.getOrganizationRoleName().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationalUnits() == null ? 0 : this.getOrganizationalUnits().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionType() == null ? 0 : this.getPermissionType().hashCode());
        hashCode = 31 * hashCode + (this.getStackSetName() == null ? 0 : this.getStackSetName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceRoleArn() == null ? 0 : this.getWorkspaceRoleArn().hashCode());
        return hashCode;
    }

    public WorkspaceDescription clone() {
        try {
            return (WorkspaceDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkspaceDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

