/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedblockchainquery.model.QueryNetwork;
import com.amazonaws.services.managedblockchainquery.model.transform.ContractIdentifierMarshaller;
import java.io.Serializable;

public class ContractIdentifier
implements Serializable,
Cloneable,
StructuredPojo {
    private String network;
    private String contractAddress;

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getNetwork() {
        return this.network;
    }

    public ContractIdentifier withNetwork(String network) {
        this.setNetwork(network);
        return this;
    }

    public ContractIdentifier withNetwork(QueryNetwork network) {
        this.network = network.toString();
        return this;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public ContractIdentifier withContractAddress(String contractAddress) {
        this.setContractAddress(contractAddress);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetwork() != null) {
            sb.append("Network: ").append(this.getNetwork()).append(",");
        }
        if (this.getContractAddress() != null) {
            sb.append("ContractAddress: ").append(this.getContractAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContractIdentifier)) {
            return false;
        }
        ContractIdentifier other = (ContractIdentifier)obj;
        if (other.getNetwork() == null ^ this.getNetwork() == null) {
            return false;
        }
        if (other.getNetwork() != null && !other.getNetwork().equals(this.getNetwork())) {
            return false;
        }
        if (other.getContractAddress() == null ^ this.getContractAddress() == null) {
            return false;
        }
        return other.getContractAddress() == null || other.getContractAddress().equals(this.getContractAddress());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetwork() == null ? 0 : this.getNetwork().hashCode());
        hashCode = 31 * hashCode + (this.getContractAddress() == null ? 0 : this.getContractAddress().hashCode());
        return hashCode;
    }

    public ContractIdentifier clone() {
        try {
            return (ContractIdentifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContractIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

