/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.managedblockchainquery.AmazonManagedBlockchainQuery;
import com.amazonaws.services.managedblockchainquery.AmazonManagedBlockchainQueryClientBuilder;
import com.amazonaws.services.managedblockchainquery.model.AmazonManagedBlockchainQueryException;
import com.amazonaws.services.managedblockchainquery.model.BatchGetTokenBalanceRequest;
import com.amazonaws.services.managedblockchainquery.model.BatchGetTokenBalanceResult;
import com.amazonaws.services.managedblockchainquery.model.GetTokenBalanceRequest;
import com.amazonaws.services.managedblockchainquery.model.GetTokenBalanceResult;
import com.amazonaws.services.managedblockchainquery.model.GetTransactionRequest;
import com.amazonaws.services.managedblockchainquery.model.GetTransactionResult;
import com.amazonaws.services.managedblockchainquery.model.ListTokenBalancesRequest;
import com.amazonaws.services.managedblockchainquery.model.ListTokenBalancesResult;
import com.amazonaws.services.managedblockchainquery.model.ListTransactionEventsRequest;
import com.amazonaws.services.managedblockchainquery.model.ListTransactionEventsResult;
import com.amazonaws.services.managedblockchainquery.model.ListTransactionsRequest;
import com.amazonaws.services.managedblockchainquery.model.ListTransactionsResult;
import com.amazonaws.services.managedblockchainquery.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.BatchGetTokenBalanceRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.BatchGetTokenBalanceResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.GetTokenBalanceRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.GetTokenBalanceResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.GetTransactionRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.GetTransactionResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ListTokenBalancesRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ListTokenBalancesResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ListTransactionEventsRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ListTransactionEventsResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ListTransactionsRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ListTransactionsResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.managedblockchainquery.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonManagedBlockchainQueryClient
extends AmazonWebServiceClient
implements AmazonManagedBlockchainQuery {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonManagedBlockchainQuery.class);
    private static final String DEFAULT_SIGNING_NAME = "managedblockchain-query";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonManagedBlockchainQueryException.class));

    public static AmazonManagedBlockchainQueryClientBuilder builder() {
        return AmazonManagedBlockchainQueryClientBuilder.standard();
    }

    AmazonManagedBlockchainQueryClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonManagedBlockchainQueryClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("managedblockchain-query.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/managedblockchainquery/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/managedblockchainquery/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchGetTokenBalanceResult batchGetTokenBalance(BatchGetTokenBalanceRequest request) {
        request = (BatchGetTokenBalanceRequest)this.beforeClientExecution(request);
        return this.executeBatchGetTokenBalance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetTokenBalanceResult executeBatchGetTokenBalance(BatchGetTokenBalanceRequest batchGetTokenBalanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetTokenBalanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetTokenBalanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetTokenBalanceRequestProtocolMarshaller(protocolFactory).marshall((BatchGetTokenBalanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetTokenBalanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetTokenBalance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetTokenBalanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetTokenBalanceResult batchGetTokenBalanceResult = (BatchGetTokenBalanceResult)response.getAwsResponse();
            return batchGetTokenBalanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTokenBalanceResult getTokenBalance(GetTokenBalanceRequest request) {
        request = (GetTokenBalanceRequest)this.beforeClientExecution(request);
        return this.executeGetTokenBalance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTokenBalanceResult executeGetTokenBalance(GetTokenBalanceRequest getTokenBalanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTokenBalanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTokenBalanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTokenBalanceRequestProtocolMarshaller(protocolFactory).marshall((GetTokenBalanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTokenBalanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTokenBalance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTokenBalanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTokenBalanceResult getTokenBalanceResult = (GetTokenBalanceResult)response.getAwsResponse();
            return getTokenBalanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTransactionResult getTransaction(GetTransactionRequest request) {
        request = (GetTransactionRequest)this.beforeClientExecution(request);
        return this.executeGetTransaction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTransactionResult executeGetTransaction(GetTransactionRequest getTransactionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTransactionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTransactionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTransactionRequestProtocolMarshaller(protocolFactory).marshall((GetTransactionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTransactionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTransaction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTransactionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTransactionResult getTransactionResult = (GetTransactionResult)response.getAwsResponse();
            return getTransactionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTokenBalancesResult listTokenBalances(ListTokenBalancesRequest request) {
        request = (ListTokenBalancesRequest)this.beforeClientExecution(request);
        return this.executeListTokenBalances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTokenBalancesResult executeListTokenBalances(ListTokenBalancesRequest listTokenBalancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTokenBalancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTokenBalancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTokenBalancesRequestProtocolMarshaller(protocolFactory).marshall((ListTokenBalancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTokenBalancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTokenBalances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTokenBalancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTokenBalancesResult listTokenBalancesResult = (ListTokenBalancesResult)response.getAwsResponse();
            return listTokenBalancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTransactionEventsResult listTransactionEvents(ListTransactionEventsRequest request) {
        request = (ListTransactionEventsRequest)this.beforeClientExecution(request);
        return this.executeListTransactionEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTransactionEventsResult executeListTransactionEvents(ListTransactionEventsRequest listTransactionEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTransactionEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTransactionEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTransactionEventsRequestProtocolMarshaller(protocolFactory).marshall((ListTransactionEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTransactionEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTransactionEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTransactionEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTransactionEventsResult listTransactionEventsResult = (ListTransactionEventsResult)response.getAwsResponse();
            return listTransactionEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTransactionsResult listTransactions(ListTransactionsRequest request) {
        request = (ListTransactionsRequest)this.beforeClientExecution(request);
        return this.executeListTransactions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTransactionsResult executeListTransactions(ListTransactionsRequest listTransactionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTransactionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTransactionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTransactionsRequestProtocolMarshaller(protocolFactory).marshall((ListTransactionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTransactionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTransactions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTransactionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTransactionsResult listTransactionsResult = (ListTransactionsResult)response.getAwsResponse();
            return listTransactionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

