/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchain.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.managedblockchain.model.ProposalSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListProposalsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ProposalSummary> proposals;
    private String nextToken;

    public List<ProposalSummary> getProposals() {
        return this.proposals;
    }

    public void setProposals(Collection<ProposalSummary> proposals) {
        if (proposals == null) {
            this.proposals = null;
            return;
        }
        this.proposals = new ArrayList<ProposalSummary>(proposals);
    }

    public ListProposalsResult withProposals(ProposalSummary ... proposals) {
        if (this.proposals == null) {
            this.setProposals(new ArrayList<ProposalSummary>(proposals.length));
        }
        for (ProposalSummary ele : proposals) {
            this.proposals.add(ele);
        }
        return this;
    }

    public ListProposalsResult withProposals(Collection<ProposalSummary> proposals) {
        this.setProposals(proposals);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListProposalsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProposals() != null) {
            sb.append("Proposals: ").append(this.getProposals()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProposalsResult)) {
            return false;
        }
        ListProposalsResult other = (ListProposalsResult)obj;
        if (other.getProposals() == null ^ this.getProposals() == null) {
            return false;
        }
        if (other.getProposals() != null && !other.getProposals().equals(this.getProposals())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProposals() == null ? 0 : this.getProposals().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListProposalsResult clone() {
        try {
            return (ListProposalsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

