/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mailmanager.model.Rule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRuleSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String ruleSetId;
    private String ruleSetName;
    private List<Rule> rules;

    public void setRuleSetId(String ruleSetId) {
        this.ruleSetId = ruleSetId;
    }

    public String getRuleSetId() {
        return this.ruleSetId;
    }

    public UpdateRuleSetRequest withRuleSetId(String ruleSetId) {
        this.setRuleSetId(ruleSetId);
        return this;
    }

    public void setRuleSetName(String ruleSetName) {
        this.ruleSetName = ruleSetName;
    }

    public String getRuleSetName() {
        return this.ruleSetName;
    }

    public UpdateRuleSetRequest withRuleSetName(String ruleSetName) {
        this.setRuleSetName(ruleSetName);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public UpdateRuleSetRequest withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public UpdateRuleSetRequest withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleSetId() != null) {
            sb.append("RuleSetId: ").append(this.getRuleSetId()).append(",");
        }
        if (this.getRuleSetName() != null) {
            sb.append("RuleSetName: ").append(this.getRuleSetName()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleSetRequest)) {
            return false;
        }
        UpdateRuleSetRequest other = (UpdateRuleSetRequest)obj;
        if (other.getRuleSetId() == null ^ this.getRuleSetId() == null) {
            return false;
        }
        if (other.getRuleSetId() != null && !other.getRuleSetId().equals(this.getRuleSetId())) {
            return false;
        }
        if (other.getRuleSetName() == null ^ this.getRuleSetName() == null) {
            return false;
        }
        if (other.getRuleSetName() != null && !other.getRuleSetName().equals(this.getRuleSetName())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleSetId() == null ? 0 : this.getRuleSetId().hashCode());
        hashCode = 31 * hashCode + (this.getRuleSetName() == null ? 0 : this.getRuleSetName().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public UpdateRuleSetRequest clone() {
        return (UpdateRuleSetRequest)super.clone();
    }
}

