/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mailmanager.model.MessageBody;

@SdkInternalApi
public class MessageBodyMarshaller {
    private static final MarshallingInfo<String> HTML_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Html").build();
    private static final MarshallingInfo<Boolean> MESSAGEMALFORMED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageMalformed").build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").build();
    private static final MessageBodyMarshaller instance = new MessageBodyMarshaller();

    public static MessageBodyMarshaller getInstance() {
        return instance;
    }

    public void marshall(MessageBody messageBody, ProtocolMarshaller protocolMarshaller) {
        if (messageBody == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)messageBody.getHtml(), HTML_BINDING);
            protocolMarshaller.marshall((Object)messageBody.getMessageMalformed(), MESSAGEMALFORMED_BINDING);
            protocolMarshaller.marshall((Object)messageBody.getText(), TEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

