/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.macie.model.S3ResourceClassification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssociateS3ResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String memberAccountId;
    private List<S3ResourceClassification> s3Resources;

    public void setMemberAccountId(String memberAccountId) {
        this.memberAccountId = memberAccountId;
    }

    public String getMemberAccountId() {
        return this.memberAccountId;
    }

    public AssociateS3ResourcesRequest withMemberAccountId(String memberAccountId) {
        this.setMemberAccountId(memberAccountId);
        return this;
    }

    public List<S3ResourceClassification> getS3Resources() {
        return this.s3Resources;
    }

    public void setS3Resources(Collection<S3ResourceClassification> s3Resources) {
        if (s3Resources == null) {
            this.s3Resources = null;
            return;
        }
        this.s3Resources = new ArrayList<S3ResourceClassification>(s3Resources);
    }

    public AssociateS3ResourcesRequest withS3Resources(S3ResourceClassification ... s3Resources) {
        if (this.s3Resources == null) {
            this.setS3Resources(new ArrayList<S3ResourceClassification>(s3Resources.length));
        }
        for (S3ResourceClassification ele : s3Resources) {
            this.s3Resources.add(ele);
        }
        return this;
    }

    public AssociateS3ResourcesRequest withS3Resources(Collection<S3ResourceClassification> s3Resources) {
        this.setS3Resources(s3Resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMemberAccountId() != null) {
            sb.append("MemberAccountId: ").append(this.getMemberAccountId()).append(",");
        }
        if (this.getS3Resources() != null) {
            sb.append("S3Resources: ").append(this.getS3Resources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateS3ResourcesRequest)) {
            return false;
        }
        AssociateS3ResourcesRequest other = (AssociateS3ResourcesRequest)obj;
        if (other.getMemberAccountId() == null ^ this.getMemberAccountId() == null) {
            return false;
        }
        if (other.getMemberAccountId() != null && !other.getMemberAccountId().equals(this.getMemberAccountId())) {
            return false;
        }
        if (other.getS3Resources() == null ^ this.getS3Resources() == null) {
            return false;
        }
        return other.getS3Resources() == null || other.getS3Resources().equals(this.getS3Resources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMemberAccountId() == null ? 0 : this.getMemberAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getS3Resources() == null ? 0 : this.getS3Resources().hashCode());
        return hashCode;
    }

    public AssociateS3ResourcesRequest clone() {
        return (AssociateS3ResourcesRequest)super.clone();
    }
}

