/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.machinelearning.model.CreateMLModelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class CreateMLModelRequestMarshaller
implements Marshaller<Request<CreateMLModelRequest>, CreateMLModelRequest> {
    public Request<CreateMLModelRequest> marshall(CreateMLModelRequest createMLModelRequest) {
        if (createMLModelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createMLModelRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.CreateMLModel");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalMap parametersMap;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (createMLModelRequest.getMLModelId() != null) {
                jsonGenerator.writeFieldName("MLModelId").writeValue(createMLModelRequest.getMLModelId());
            }
            if (createMLModelRequest.getMLModelName() != null) {
                jsonGenerator.writeFieldName("MLModelName").writeValue(createMLModelRequest.getMLModelName());
            }
            if (createMLModelRequest.getMLModelType() != null) {
                jsonGenerator.writeFieldName("MLModelType").writeValue(createMLModelRequest.getMLModelType());
            }
            if (!(parametersMap = (SdkInternalMap)createMLModelRequest.getParameters()).isEmpty() || !parametersMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)parametersMapValue.getKey());
                    jsonGenerator.writeValue((String)parametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (createMLModelRequest.getTrainingDataSourceId() != null) {
                jsonGenerator.writeFieldName("TrainingDataSourceId").writeValue(createMLModelRequest.getTrainingDataSourceId());
            }
            if (createMLModelRequest.getRecipe() != null) {
                jsonGenerator.writeFieldName("Recipe").writeValue(createMLModelRequest.getRecipe());
            }
            if (createMLModelRequest.getRecipeUri() != null) {
                jsonGenerator.writeFieldName("RecipeUri").writeValue(createMLModelRequest.getRecipeUri());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

