/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.machinelearning.model.Evaluation;
import com.amazonaws.services.machinelearning.model.transform.PerformanceMetricsJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class EvaluationJsonMarshaller {
    private static EvaluationJsonMarshaller instance;

    public void marshall(Evaluation evaluation, SdkJsonGenerator jsonGenerator) {
        if (evaluation == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (evaluation.getEvaluationId() != null) {
                jsonGenerator.writeFieldName("EvaluationId").writeValue(evaluation.getEvaluationId());
            }
            if (evaluation.getMLModelId() != null) {
                jsonGenerator.writeFieldName("MLModelId").writeValue(evaluation.getMLModelId());
            }
            if (evaluation.getEvaluationDataSourceId() != null) {
                jsonGenerator.writeFieldName("EvaluationDataSourceId").writeValue(evaluation.getEvaluationDataSourceId());
            }
            if (evaluation.getInputDataLocationS3() != null) {
                jsonGenerator.writeFieldName("InputDataLocationS3").writeValue(evaluation.getInputDataLocationS3());
            }
            if (evaluation.getCreatedByIamUser() != null) {
                jsonGenerator.writeFieldName("CreatedByIamUser").writeValue(evaluation.getCreatedByIamUser());
            }
            if (evaluation.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(evaluation.getCreatedAt());
            }
            if (evaluation.getLastUpdatedAt() != null) {
                jsonGenerator.writeFieldName("LastUpdatedAt").writeValue(evaluation.getLastUpdatedAt());
            }
            if (evaluation.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(evaluation.getName());
            }
            if (evaluation.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(evaluation.getStatus());
            }
            if (evaluation.getPerformanceMetrics() != null) {
                jsonGenerator.writeFieldName("PerformanceMetrics");
                PerformanceMetricsJsonMarshaller.getInstance().marshall(evaluation.getPerformanceMetrics(), jsonGenerator);
            }
            if (evaluation.getMessage() != null) {
                jsonGenerator.writeFieldName("Message").writeValue(evaluation.getMessage());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EvaluationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EvaluationJsonMarshaller();
        }
        return instance;
    }
}

