/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class PredictRequestMarshaller
implements Marshaller<Request<PredictRequest>, PredictRequest> {
    public Request<PredictRequest> marshall(PredictRequest predictRequest) {
        if (predictRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)predictRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.Predict");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalMap recordMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (predictRequest.getMLModelId() != null) {
                jsonWriter.key("MLModelId").value((Object)predictRequest.getMLModelId());
            }
            if (!(recordMap = (SdkInternalMap)predictRequest.getRecord()).isEmpty() || !recordMap.isAutoConstruct()) {
                jsonWriter.key("Record");
                jsonWriter.object();
                for (Map.Entry recordMapValue : recordMap.entrySet()) {
                    if (recordMapValue.getValue() == null) continue;
                    jsonWriter.key((String)recordMapValue.getKey());
                    jsonWriter.value(recordMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (predictRequest.getPredictEndpoint() != null) {
                jsonWriter.key("PredictEndpoint").value((Object)predictRequest.getPredictEndpoint());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

