/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.machinelearning.model.RedshiftDataSpec;
import com.amazonaws.services.machinelearning.model.transform.RedshiftDatabaseCredentialsJsonMarshaller;
import com.amazonaws.services.machinelearning.model.transform.RedshiftDatabaseJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RedshiftDataSpecJsonMarshaller {
    private static RedshiftDataSpecJsonMarshaller instance;

    public void marshall(RedshiftDataSpec redshiftDataSpec, JSONWriter jsonWriter) {
        if (redshiftDataSpec == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (redshiftDataSpec.getDatabaseInformation() != null) {
                jsonWriter.key("DatabaseInformation");
                RedshiftDatabaseJsonMarshaller.getInstance().marshall(redshiftDataSpec.getDatabaseInformation(), jsonWriter);
            }
            if (redshiftDataSpec.getSelectSqlQuery() != null) {
                jsonWriter.key("SelectSqlQuery").value((Object)redshiftDataSpec.getSelectSqlQuery());
            }
            if (redshiftDataSpec.getDatabaseCredentials() != null) {
                jsonWriter.key("DatabaseCredentials");
                RedshiftDatabaseCredentialsJsonMarshaller.getInstance().marshall(redshiftDataSpec.getDatabaseCredentials(), jsonWriter);
            }
            if (redshiftDataSpec.getS3StagingLocation() != null) {
                jsonWriter.key("S3StagingLocation").value((Object)redshiftDataSpec.getS3StagingLocation());
            }
            if (redshiftDataSpec.getDataRearrangement() != null) {
                jsonWriter.key("DataRearrangement").value((Object)redshiftDataSpec.getDataRearrangement());
            }
            if (redshiftDataSpec.getDataSchema() != null) {
                jsonWriter.key("DataSchema").value((Object)redshiftDataSpec.getDataSchema());
            }
            if (redshiftDataSpec.getDataSchemaUri() != null) {
                jsonWriter.key("DataSchemaUri").value((Object)redshiftDataSpec.getDataSchemaUri());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RedshiftDataSpecJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RedshiftDataSpecJsonMarshaller();
        }
        return instance;
    }
}

