/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import com.amazonaws.services.machinelearning.model.RedshiftDataSpec;
import com.amazonaws.services.machinelearning.model.RedshiftDatabase;
import com.amazonaws.services.machinelearning.model.RedshiftDatabaseCredentials;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateDataSourceFromRedshiftRequestMarshaller
implements Marshaller<Request<CreateDataSourceFromRedshiftRequest>, CreateDataSourceFromRedshiftRequest> {
    public Request<CreateDataSourceFromRedshiftRequest> marshall(CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) {
        if (createDataSourceFromRedshiftRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDataSourceFromRedshiftRequest, "AmazonMachineLearning");
        String target = "AmazonML_20141212.CreateDataSourceFromRedshift";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            RedshiftDataSpec dataSpec;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createDataSourceFromRedshiftRequest.getDataSourceId() != null) {
                jsonWriter.key("DataSourceId").value((Object)createDataSourceFromRedshiftRequest.getDataSourceId());
            }
            if (createDataSourceFromRedshiftRequest.getDataSourceName() != null) {
                jsonWriter.key("DataSourceName").value((Object)createDataSourceFromRedshiftRequest.getDataSourceName());
            }
            if ((dataSpec = createDataSourceFromRedshiftRequest.getDataSpec()) != null) {
                RedshiftDatabaseCredentials databaseCredentials;
                jsonWriter.key("DataSpec");
                jsonWriter.object();
                RedshiftDatabase databaseInformation = dataSpec.getDatabaseInformation();
                if (databaseInformation != null) {
                    jsonWriter.key("DatabaseInformation");
                    jsonWriter.object();
                    if (databaseInformation.getDatabaseName() != null) {
                        jsonWriter.key("DatabaseName").value((Object)databaseInformation.getDatabaseName());
                    }
                    if (databaseInformation.getClusterIdentifier() != null) {
                        jsonWriter.key("ClusterIdentifier").value((Object)databaseInformation.getClusterIdentifier());
                    }
                    jsonWriter.endObject();
                }
                if (dataSpec.getSelectSqlQuery() != null) {
                    jsonWriter.key("SelectSqlQuery").value((Object)dataSpec.getSelectSqlQuery());
                }
                if ((databaseCredentials = dataSpec.getDatabaseCredentials()) != null) {
                    jsonWriter.key("DatabaseCredentials");
                    jsonWriter.object();
                    if (databaseCredentials.getUsername() != null) {
                        jsonWriter.key("Username").value((Object)databaseCredentials.getUsername());
                    }
                    if (databaseCredentials.getPassword() != null) {
                        jsonWriter.key("Password").value((Object)databaseCredentials.getPassword());
                    }
                    jsonWriter.endObject();
                }
                if (dataSpec.getS3StagingLocation() != null) {
                    jsonWriter.key("S3StagingLocation").value((Object)dataSpec.getS3StagingLocation());
                }
                if (dataSpec.getDataRearrangement() != null) {
                    jsonWriter.key("DataRearrangement").value((Object)dataSpec.getDataRearrangement());
                }
                if (dataSpec.getDataSchema() != null) {
                    jsonWriter.key("DataSchema").value((Object)dataSpec.getDataSchema());
                }
                if (dataSpec.getDataSchemaUri() != null) {
                    jsonWriter.key("DataSchemaUri").value((Object)dataSpec.getDataSchemaUri());
                }
                jsonWriter.endObject();
            }
            if (createDataSourceFromRedshiftRequest.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value((Object)createDataSourceFromRedshiftRequest.getRoleARN());
            }
            if (createDataSourceFromRedshiftRequest.isComputeStatistics() != null) {
                jsonWriter.key("ComputeStatistics").value((Object)createDataSourceFromRedshiftRequest.isComputeStatistics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

