/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.machinelearning.model.MLModel;
import com.amazonaws.services.machinelearning.model.transform.RealtimeEndpointInfoJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class MLModelJsonMarshaller {
    private static MLModelJsonMarshaller instance;

    public void marshall(MLModel mLModel, JSONWriter jsonWriter) {
        if (mLModel == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap trainingParametersMap;
            jsonWriter.object();
            if (mLModel.getMLModelId() != null) {
                jsonWriter.key("MLModelId").value((Object)mLModel.getMLModelId());
            }
            if (mLModel.getTrainingDataSourceId() != null) {
                jsonWriter.key("TrainingDataSourceId").value((Object)mLModel.getTrainingDataSourceId());
            }
            if (mLModel.getCreatedByIamUser() != null) {
                jsonWriter.key("CreatedByIamUser").value((Object)mLModel.getCreatedByIamUser());
            }
            if (mLModel.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value(mLModel.getCreatedAt());
            }
            if (mLModel.getLastUpdatedAt() != null) {
                jsonWriter.key("LastUpdatedAt").value(mLModel.getLastUpdatedAt());
            }
            if (mLModel.getName() != null) {
                jsonWriter.key("Name").value((Object)mLModel.getName());
            }
            if (mLModel.getStatus() != null) {
                jsonWriter.key("Status").value((Object)mLModel.getStatus());
            }
            if (mLModel.getSizeInBytes() != null) {
                jsonWriter.key("SizeInBytes").value((Object)mLModel.getSizeInBytes());
            }
            if (mLModel.getEndpointInfo() != null) {
                jsonWriter.key("EndpointInfo");
                RealtimeEndpointInfoJsonMarshaller.getInstance().marshall(mLModel.getEndpointInfo(), jsonWriter);
            }
            if (!(trainingParametersMap = (SdkInternalMap)mLModel.getTrainingParameters()).isEmpty() || !trainingParametersMap.isAutoConstruct()) {
                jsonWriter.key("TrainingParameters");
                jsonWriter.object();
                for (Map.Entry trainingParametersMapValue : trainingParametersMap.entrySet()) {
                    if (trainingParametersMapValue.getValue() == null) continue;
                    jsonWriter.key((String)trainingParametersMapValue.getKey());
                    jsonWriter.value(trainingParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (mLModel.getInputDataLocationS3() != null) {
                jsonWriter.key("InputDataLocationS3").value((Object)mLModel.getInputDataLocationS3());
            }
            if (mLModel.getAlgorithm() != null) {
                jsonWriter.key("Algorithm").value((Object)mLModel.getAlgorithm());
            }
            if (mLModel.getMLModelType() != null) {
                jsonWriter.key("MLModelType").value((Object)mLModel.getMLModelType());
            }
            if (mLModel.getScoreThreshold() != null) {
                jsonWriter.key("ScoreThreshold").value((Object)mLModel.getScoreThreshold());
            }
            if (mLModel.getScoreThresholdLastUpdatedAt() != null) {
                jsonWriter.key("ScoreThresholdLastUpdatedAt").value(mLModel.getScoreThresholdLastUpdatedAt());
            }
            if (mLModel.getMessage() != null) {
                jsonWriter.key("Message").value((Object)mLModel.getMessage());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MLModelJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MLModelJsonMarshaller();
        }
        return instance;
    }
}

