/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.CloudWatchConfig;

@SdkInternalApi
public class CloudWatchConfigMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<StructuredPojo> BACKTESTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackTestConfiguration").build();
    private static final CloudWatchConfigMarshaller instance = new CloudWatchConfigMarshaller();

    public static CloudWatchConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudWatchConfig cloudWatchConfig, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudWatchConfig.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchConfig.getBackTestConfiguration(), BACKTESTCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

