/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.logs.model.Anomaly;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListAnomaliesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Anomaly> anomalies;
    private String nextToken;

    public List<Anomaly> getAnomalies() {
        if (this.anomalies == null) {
            this.anomalies = new SdkInternalList();
        }
        return this.anomalies;
    }

    public void setAnomalies(Collection<Anomaly> anomalies) {
        if (anomalies == null) {
            this.anomalies = null;
            return;
        }
        this.anomalies = new SdkInternalList(anomalies);
    }

    public ListAnomaliesResult withAnomalies(Anomaly ... anomalies) {
        if (this.anomalies == null) {
            this.setAnomalies((Collection<Anomaly>)new SdkInternalList(anomalies.length));
        }
        for (Anomaly ele : anomalies) {
            this.anomalies.add((Object)ele);
        }
        return this;
    }

    public ListAnomaliesResult withAnomalies(Collection<Anomaly> anomalies) {
        this.setAnomalies(anomalies);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAnomaliesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAnomalies() != null) {
            sb.append("Anomalies: ").append(this.getAnomalies()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomaliesResult)) {
            return false;
        }
        ListAnomaliesResult other = (ListAnomaliesResult)obj;
        if (other.getAnomalies() == null ^ this.getAnomalies() == null) {
            return false;
        }
        if (other.getAnomalies() != null && !other.getAnomalies().equals(this.getAnomalies())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAnomalies() == null ? 0 : this.getAnomalies().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAnomaliesResult clone() {
        try {
            return (ListAnomaliesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

