/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.FilterLogEventsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class FilterLogEventsRequestMarshaller
implements Marshaller<Request<FilterLogEventsRequest>, FilterLogEventsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public FilterLogEventsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<FilterLogEventsRequest> marshall(FilterLogEventsRequest filterLogEventsRequest) {
        if (filterLogEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)filterLogEventsRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.FilterLogEvents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList logStreamNamesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (filterLogEventsRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(filterLogEventsRequest.getLogGroupName());
            }
            if (!(logStreamNamesList = (SdkInternalList)filterLogEventsRequest.getLogStreamNames()).isEmpty() || !logStreamNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("logStreamNames");
                jsonGenerator.writeStartArray();
                for (String logStreamNamesListValue : logStreamNamesList) {
                    if (logStreamNamesListValue == null) continue;
                    jsonGenerator.writeValue(logStreamNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (filterLogEventsRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("startTime").writeValue(filterLogEventsRequest.getStartTime().longValue());
            }
            if (filterLogEventsRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("endTime").writeValue(filterLogEventsRequest.getEndTime().longValue());
            }
            if (filterLogEventsRequest.getFilterPattern() != null) {
                jsonGenerator.writeFieldName("filterPattern").writeValue(filterLogEventsRequest.getFilterPattern());
            }
            if (filterLogEventsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(filterLogEventsRequest.getNextToken());
            }
            if (filterLogEventsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(filterLogEventsRequest.getLimit().intValue());
            }
            if (filterLogEventsRequest.getInterleaved() != null) {
                jsonGenerator.writeFieldName("interleaved").writeValue(filterLogEventsRequest.getInterleaved().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

