/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.MetricTransformation;
import com.amazonaws.services.logs.model.PutMetricFilterRequest;
import com.amazonaws.services.logs.model.transform.MetricTransformationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutMetricFilterRequestMarshaller
implements Marshaller<Request<PutMetricFilterRequest>, PutMetricFilterRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutMetricFilterRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutMetricFilterRequest> marshall(PutMetricFilterRequest putMetricFilterRequest) {
        if (putMetricFilterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMetricFilterRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.PutMetricFilter");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList metricTransformationsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putMetricFilterRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(putMetricFilterRequest.getLogGroupName());
            }
            if (putMetricFilterRequest.getFilterName() != null) {
                jsonGenerator.writeFieldName("filterName").writeValue(putMetricFilterRequest.getFilterName());
            }
            if (putMetricFilterRequest.getFilterPattern() != null) {
                jsonGenerator.writeFieldName("filterPattern").writeValue(putMetricFilterRequest.getFilterPattern());
            }
            if (!(metricTransformationsList = (SdkInternalList)putMetricFilterRequest.getMetricTransformations()).isEmpty() || !metricTransformationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("metricTransformations");
                jsonGenerator.writeStartArray();
                for (MetricTransformation metricTransformationsListValue : metricTransformationsList) {
                    if (metricTransformationsListValue == null) continue;
                    MetricTransformationJsonMarshaller.getInstance().marshall(metricTransformationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

