/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.DescribeMetricFiltersRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeMetricFiltersRequestMarshaller
implements Marshaller<Request<DescribeMetricFiltersRequest>, DescribeMetricFiltersRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeMetricFiltersRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeMetricFiltersRequest> marshall(DescribeMetricFiltersRequest describeMetricFiltersRequest) {
        if (describeMetricFiltersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeMetricFiltersRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.DescribeMetricFilters");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeMetricFiltersRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(describeMetricFiltersRequest.getLogGroupName());
            }
            if (describeMetricFiltersRequest.getFilterNamePrefix() != null) {
                jsonGenerator.writeFieldName("filterNamePrefix").writeValue(describeMetricFiltersRequest.getFilterNamePrefix());
            }
            if (describeMetricFiltersRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeMetricFiltersRequest.getNextToken());
            }
            if (describeMetricFiltersRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(describeMetricFiltersRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

