/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.LogGroup;

public class LogGroupJsonMarshaller {
    private static LogGroupJsonMarshaller instance;

    public void marshall(LogGroup logGroup, StructuredJsonGenerator jsonGenerator) {
        if (logGroup == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (logGroup.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(logGroup.getLogGroupName());
            }
            if (logGroup.getCreationTime() != null) {
                jsonGenerator.writeFieldName("creationTime").writeValue(logGroup.getCreationTime().longValue());
            }
            if (logGroup.getRetentionInDays() != null) {
                jsonGenerator.writeFieldName("retentionInDays").writeValue(logGroup.getRetentionInDays().intValue());
            }
            if (logGroup.getMetricFilterCount() != null) {
                jsonGenerator.writeFieldName("metricFilterCount").writeValue(logGroup.getMetricFilterCount().intValue());
            }
            if (logGroup.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(logGroup.getArn());
            }
            if (logGroup.getStoredBytes() != null) {
                jsonGenerator.writeFieldName("storedBytes").writeValue(logGroup.getStoredBytes().longValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LogGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LogGroupJsonMarshaller();
        }
        return instance;
    }
}

