/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.logs.model.LogStream;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class LogStreamJsonMarshaller {
    private static LogStreamJsonMarshaller instance;

    public void marshall(LogStream logStream, StructuredJsonGenerator jsonGenerator) {
        if (logStream == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (logStream.getLogStreamName() != null) {
                jsonGenerator.writeFieldName("logStreamName").writeValue(logStream.getLogStreamName());
            }
            if (logStream.getCreationTime() != null) {
                jsonGenerator.writeFieldName("creationTime").writeValue(logStream.getCreationTime().longValue());
            }
            if (logStream.getFirstEventTimestamp() != null) {
                jsonGenerator.writeFieldName("firstEventTimestamp").writeValue(logStream.getFirstEventTimestamp().longValue());
            }
            if (logStream.getLastEventTimestamp() != null) {
                jsonGenerator.writeFieldName("lastEventTimestamp").writeValue(logStream.getLastEventTimestamp().longValue());
            }
            if (logStream.getLastIngestionTime() != null) {
                jsonGenerator.writeFieldName("lastIngestionTime").writeValue(logStream.getLastIngestionTime().longValue());
            }
            if (logStream.getUploadSequenceToken() != null) {
                jsonGenerator.writeFieldName("uploadSequenceToken").writeValue(logStream.getUploadSequenceToken());
            }
            if (logStream.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(logStream.getArn());
            }
            if (logStream.getStoredBytes() != null) {
                jsonGenerator.writeFieldName("storedBytes").writeValue(logStream.getStoredBytes().longValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LogStreamJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LogStreamJsonMarshaller();
        }
        return instance;
    }
}

