/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.AppCategory;
import com.amazonaws.services.lightsail.model.InstancePlatform;
import com.amazonaws.services.lightsail.model.transform.BundleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Bundle
implements Serializable,
Cloneable,
StructuredPojo {
    private Float price;
    private Integer cpuCount;
    private Integer diskSizeInGb;
    private String bundleId;
    private String instanceType;
    private Boolean isActive;
    private String name;
    private Integer power;
    private Float ramSizeInGb;
    private Integer transferPerMonthInGb;
    private List<String> supportedPlatforms;
    private List<String> supportedAppCategories;
    private Integer publicIpv4AddressCount;

    public void setPrice(Float price) {
        this.price = price;
    }

    public Float getPrice() {
        return this.price;
    }

    public Bundle withPrice(Float price) {
        this.setPrice(price);
        return this;
    }

    public void setCpuCount(Integer cpuCount) {
        this.cpuCount = cpuCount;
    }

    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public Bundle withCpuCount(Integer cpuCount) {
        this.setCpuCount(cpuCount);
        return this;
    }

    public void setDiskSizeInGb(Integer diskSizeInGb) {
        this.diskSizeInGb = diskSizeInGb;
    }

    public Integer getDiskSizeInGb() {
        return this.diskSizeInGb;
    }

    public Bundle withDiskSizeInGb(Integer diskSizeInGb) {
        this.setDiskSizeInGb(diskSizeInGb);
        return this;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public Bundle withBundleId(String bundleId) {
        this.setBundleId(bundleId);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Bundle withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Bundle withIsActive(Boolean isActive) {
        this.setIsActive(isActive);
        return this;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Bundle withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPower(Integer power) {
        this.power = power;
    }

    public Integer getPower() {
        return this.power;
    }

    public Bundle withPower(Integer power) {
        this.setPower(power);
        return this;
    }

    public void setRamSizeInGb(Float ramSizeInGb) {
        this.ramSizeInGb = ramSizeInGb;
    }

    public Float getRamSizeInGb() {
        return this.ramSizeInGb;
    }

    public Bundle withRamSizeInGb(Float ramSizeInGb) {
        this.setRamSizeInGb(ramSizeInGb);
        return this;
    }

    public void setTransferPerMonthInGb(Integer transferPerMonthInGb) {
        this.transferPerMonthInGb = transferPerMonthInGb;
    }

    public Integer getTransferPerMonthInGb() {
        return this.transferPerMonthInGb;
    }

    public Bundle withTransferPerMonthInGb(Integer transferPerMonthInGb) {
        this.setTransferPerMonthInGb(transferPerMonthInGb);
        return this;
    }

    public List<String> getSupportedPlatforms() {
        return this.supportedPlatforms;
    }

    public void setSupportedPlatforms(Collection<String> supportedPlatforms) {
        if (supportedPlatforms == null) {
            this.supportedPlatforms = null;
            return;
        }
        this.supportedPlatforms = new ArrayList<String>(supportedPlatforms);
    }

    public Bundle withSupportedPlatforms(String ... supportedPlatforms) {
        if (this.supportedPlatforms == null) {
            this.setSupportedPlatforms(new ArrayList<String>(supportedPlatforms.length));
        }
        for (String ele : supportedPlatforms) {
            this.supportedPlatforms.add(ele);
        }
        return this;
    }

    public Bundle withSupportedPlatforms(Collection<String> supportedPlatforms) {
        this.setSupportedPlatforms(supportedPlatforms);
        return this;
    }

    public Bundle withSupportedPlatforms(InstancePlatform ... supportedPlatforms) {
        ArrayList<String> supportedPlatformsCopy = new ArrayList<String>(supportedPlatforms.length);
        for (InstancePlatform value : supportedPlatforms) {
            supportedPlatformsCopy.add(value.toString());
        }
        if (this.getSupportedPlatforms() == null) {
            this.setSupportedPlatforms(supportedPlatformsCopy);
        } else {
            this.getSupportedPlatforms().addAll(supportedPlatformsCopy);
        }
        return this;
    }

    public List<String> getSupportedAppCategories() {
        return this.supportedAppCategories;
    }

    public void setSupportedAppCategories(Collection<String> supportedAppCategories) {
        if (supportedAppCategories == null) {
            this.supportedAppCategories = null;
            return;
        }
        this.supportedAppCategories = new ArrayList<String>(supportedAppCategories);
    }

    public Bundle withSupportedAppCategories(String ... supportedAppCategories) {
        if (this.supportedAppCategories == null) {
            this.setSupportedAppCategories(new ArrayList<String>(supportedAppCategories.length));
        }
        for (String ele : supportedAppCategories) {
            this.supportedAppCategories.add(ele);
        }
        return this;
    }

    public Bundle withSupportedAppCategories(Collection<String> supportedAppCategories) {
        this.setSupportedAppCategories(supportedAppCategories);
        return this;
    }

    public Bundle withSupportedAppCategories(AppCategory ... supportedAppCategories) {
        ArrayList<String> supportedAppCategoriesCopy = new ArrayList<String>(supportedAppCategories.length);
        for (AppCategory value : supportedAppCategories) {
            supportedAppCategoriesCopy.add(value.toString());
        }
        if (this.getSupportedAppCategories() == null) {
            this.setSupportedAppCategories(supportedAppCategoriesCopy);
        } else {
            this.getSupportedAppCategories().addAll(supportedAppCategoriesCopy);
        }
        return this;
    }

    public void setPublicIpv4AddressCount(Integer publicIpv4AddressCount) {
        this.publicIpv4AddressCount = publicIpv4AddressCount;
    }

    public Integer getPublicIpv4AddressCount() {
        return this.publicIpv4AddressCount;
    }

    public Bundle withPublicIpv4AddressCount(Integer publicIpv4AddressCount) {
        this.setPublicIpv4AddressCount(publicIpv4AddressCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrice() != null) {
            sb.append("Price: ").append(this.getPrice()).append(",");
        }
        if (this.getCpuCount() != null) {
            sb.append("CpuCount: ").append(this.getCpuCount()).append(",");
        }
        if (this.getDiskSizeInGb() != null) {
            sb.append("DiskSizeInGb: ").append(this.getDiskSizeInGb()).append(",");
        }
        if (this.getBundleId() != null) {
            sb.append("BundleId: ").append(this.getBundleId()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getIsActive() != null) {
            sb.append("IsActive: ").append(this.getIsActive()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPower() != null) {
            sb.append("Power: ").append(this.getPower()).append(",");
        }
        if (this.getRamSizeInGb() != null) {
            sb.append("RamSizeInGb: ").append(this.getRamSizeInGb()).append(",");
        }
        if (this.getTransferPerMonthInGb() != null) {
            sb.append("TransferPerMonthInGb: ").append(this.getTransferPerMonthInGb()).append(",");
        }
        if (this.getSupportedPlatforms() != null) {
            sb.append("SupportedPlatforms: ").append(this.getSupportedPlatforms()).append(",");
        }
        if (this.getSupportedAppCategories() != null) {
            sb.append("SupportedAppCategories: ").append(this.getSupportedAppCategories()).append(",");
        }
        if (this.getPublicIpv4AddressCount() != null) {
            sb.append("PublicIpv4AddressCount: ").append(this.getPublicIpv4AddressCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bundle)) {
            return false;
        }
        Bundle other = (Bundle)obj;
        if (other.getPrice() == null ^ this.getPrice() == null) {
            return false;
        }
        if (other.getPrice() != null && !other.getPrice().equals(this.getPrice())) {
            return false;
        }
        if (other.getCpuCount() == null ^ this.getCpuCount() == null) {
            return false;
        }
        if (other.getCpuCount() != null && !other.getCpuCount().equals(this.getCpuCount())) {
            return false;
        }
        if (other.getDiskSizeInGb() == null ^ this.getDiskSizeInGb() == null) {
            return false;
        }
        if (other.getDiskSizeInGb() != null && !other.getDiskSizeInGb().equals(this.getDiskSizeInGb())) {
            return false;
        }
        if (other.getBundleId() == null ^ this.getBundleId() == null) {
            return false;
        }
        if (other.getBundleId() != null && !other.getBundleId().equals(this.getBundleId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getIsActive() == null ^ this.getIsActive() == null) {
            return false;
        }
        if (other.getIsActive() != null && !other.getIsActive().equals(this.getIsActive())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPower() == null ^ this.getPower() == null) {
            return false;
        }
        if (other.getPower() != null && !other.getPower().equals(this.getPower())) {
            return false;
        }
        if (other.getRamSizeInGb() == null ^ this.getRamSizeInGb() == null) {
            return false;
        }
        if (other.getRamSizeInGb() != null && !other.getRamSizeInGb().equals(this.getRamSizeInGb())) {
            return false;
        }
        if (other.getTransferPerMonthInGb() == null ^ this.getTransferPerMonthInGb() == null) {
            return false;
        }
        if (other.getTransferPerMonthInGb() != null && !other.getTransferPerMonthInGb().equals(this.getTransferPerMonthInGb())) {
            return false;
        }
        if (other.getSupportedPlatforms() == null ^ this.getSupportedPlatforms() == null) {
            return false;
        }
        if (other.getSupportedPlatforms() != null && !other.getSupportedPlatforms().equals(this.getSupportedPlatforms())) {
            return false;
        }
        if (other.getSupportedAppCategories() == null ^ this.getSupportedAppCategories() == null) {
            return false;
        }
        if (other.getSupportedAppCategories() != null && !other.getSupportedAppCategories().equals(this.getSupportedAppCategories())) {
            return false;
        }
        if (other.getPublicIpv4AddressCount() == null ^ this.getPublicIpv4AddressCount() == null) {
            return false;
        }
        return other.getPublicIpv4AddressCount() == null || other.getPublicIpv4AddressCount().equals(this.getPublicIpv4AddressCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrice() == null ? 0 : this.getPrice().hashCode());
        hashCode = 31 * hashCode + (this.getCpuCount() == null ? 0 : this.getCpuCount().hashCode());
        hashCode = 31 * hashCode + (this.getDiskSizeInGb() == null ? 0 : this.getDiskSizeInGb().hashCode());
        hashCode = 31 * hashCode + (this.getBundleId() == null ? 0 : this.getBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getIsActive() == null ? 0 : this.getIsActive().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPower() == null ? 0 : this.getPower().hashCode());
        hashCode = 31 * hashCode + (this.getRamSizeInGb() == null ? 0 : this.getRamSizeInGb().hashCode());
        hashCode = 31 * hashCode + (this.getTransferPerMonthInGb() == null ? 0 : this.getTransferPerMonthInGb().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedPlatforms() == null ? 0 : this.getSupportedPlatforms().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedAppCategories() == null ? 0 : this.getSupportedAppCategories().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIpv4AddressCount() == null ? 0 : this.getPublicIpv4AddressCount().hashCode());
        return hashCode;
    }

    public Bundle clone() {
        try {
            return (Bundle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BundleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

