/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.CacheBehavior;
import com.amazonaws.services.lightsail.model.CacheBehaviorPerPath;
import com.amazonaws.services.lightsail.model.CacheSettings;
import com.amazonaws.services.lightsail.model.InputOrigin;
import com.amazonaws.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateDistributionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String distributionName;
    private InputOrigin origin;
    private CacheBehavior defaultCacheBehavior;
    private CacheSettings cacheBehaviorSettings;
    private List<CacheBehaviorPerPath> cacheBehaviors;
    private Boolean isEnabled;
    private String viewerMinimumTlsProtocolVersion;
    private String certificateName;
    private Boolean useDefaultCertificate;

    public void setDistributionName(String distributionName) {
        this.distributionName = distributionName;
    }

    public String getDistributionName() {
        return this.distributionName;
    }

    public UpdateDistributionRequest withDistributionName(String distributionName) {
        this.setDistributionName(distributionName);
        return this;
    }

    public void setOrigin(InputOrigin origin) {
        this.origin = origin;
    }

    public InputOrigin getOrigin() {
        return this.origin;
    }

    public UpdateDistributionRequest withOrigin(InputOrigin origin) {
        this.setOrigin(origin);
        return this;
    }

    public void setDefaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
        this.defaultCacheBehavior = defaultCacheBehavior;
    }

    public CacheBehavior getDefaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public UpdateDistributionRequest withDefaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
        this.setDefaultCacheBehavior(defaultCacheBehavior);
        return this;
    }

    public void setCacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
        this.cacheBehaviorSettings = cacheBehaviorSettings;
    }

    public CacheSettings getCacheBehaviorSettings() {
        return this.cacheBehaviorSettings;
    }

    public UpdateDistributionRequest withCacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
        this.setCacheBehaviorSettings(cacheBehaviorSettings);
        return this;
    }

    public List<CacheBehaviorPerPath> getCacheBehaviors() {
        return this.cacheBehaviors;
    }

    public void setCacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
        if (cacheBehaviors == null) {
            this.cacheBehaviors = null;
            return;
        }
        this.cacheBehaviors = new ArrayList<CacheBehaviorPerPath>(cacheBehaviors);
    }

    public UpdateDistributionRequest withCacheBehaviors(CacheBehaviorPerPath ... cacheBehaviors) {
        if (this.cacheBehaviors == null) {
            this.setCacheBehaviors(new ArrayList<CacheBehaviorPerPath>(cacheBehaviors.length));
        }
        for (CacheBehaviorPerPath ele : cacheBehaviors) {
            this.cacheBehaviors.add(ele);
        }
        return this;
    }

    public UpdateDistributionRequest withCacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
        this.setCacheBehaviors(cacheBehaviors);
        return this;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public UpdateDistributionRequest withIsEnabled(Boolean isEnabled) {
        this.setIsEnabled(isEnabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public void setViewerMinimumTlsProtocolVersion(String viewerMinimumTlsProtocolVersion) {
        this.viewerMinimumTlsProtocolVersion = viewerMinimumTlsProtocolVersion;
    }

    public String getViewerMinimumTlsProtocolVersion() {
        return this.viewerMinimumTlsProtocolVersion;
    }

    public UpdateDistributionRequest withViewerMinimumTlsProtocolVersion(String viewerMinimumTlsProtocolVersion) {
        this.setViewerMinimumTlsProtocolVersion(viewerMinimumTlsProtocolVersion);
        return this;
    }

    public UpdateDistributionRequest withViewerMinimumTlsProtocolVersion(ViewerMinimumTlsProtocolVersionEnum viewerMinimumTlsProtocolVersion) {
        this.viewerMinimumTlsProtocolVersion = viewerMinimumTlsProtocolVersion.toString();
        return this;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public UpdateDistributionRequest withCertificateName(String certificateName) {
        this.setCertificateName(certificateName);
        return this;
    }

    public void setUseDefaultCertificate(Boolean useDefaultCertificate) {
        this.useDefaultCertificate = useDefaultCertificate;
    }

    public Boolean getUseDefaultCertificate() {
        return this.useDefaultCertificate;
    }

    public UpdateDistributionRequest withUseDefaultCertificate(Boolean useDefaultCertificate) {
        this.setUseDefaultCertificate(useDefaultCertificate);
        return this;
    }

    public Boolean isUseDefaultCertificate() {
        return this.useDefaultCertificate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDistributionName() != null) {
            sb.append("DistributionName: ").append(this.getDistributionName()).append(",");
        }
        if (this.getOrigin() != null) {
            sb.append("Origin: ").append(this.getOrigin()).append(",");
        }
        if (this.getDefaultCacheBehavior() != null) {
            sb.append("DefaultCacheBehavior: ").append(this.getDefaultCacheBehavior()).append(",");
        }
        if (this.getCacheBehaviorSettings() != null) {
            sb.append("CacheBehaviorSettings: ").append(this.getCacheBehaviorSettings()).append(",");
        }
        if (this.getCacheBehaviors() != null) {
            sb.append("CacheBehaviors: ").append(this.getCacheBehaviors()).append(",");
        }
        if (this.getIsEnabled() != null) {
            sb.append("IsEnabled: ").append(this.getIsEnabled()).append(",");
        }
        if (this.getViewerMinimumTlsProtocolVersion() != null) {
            sb.append("ViewerMinimumTlsProtocolVersion: ").append(this.getViewerMinimumTlsProtocolVersion()).append(",");
        }
        if (this.getCertificateName() != null) {
            sb.append("CertificateName: ").append(this.getCertificateName()).append(",");
        }
        if (this.getUseDefaultCertificate() != null) {
            sb.append("UseDefaultCertificate: ").append(this.getUseDefaultCertificate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionRequest)) {
            return false;
        }
        UpdateDistributionRequest other = (UpdateDistributionRequest)obj;
        if (other.getDistributionName() == null ^ this.getDistributionName() == null) {
            return false;
        }
        if (other.getDistributionName() != null && !other.getDistributionName().equals(this.getDistributionName())) {
            return false;
        }
        if (other.getOrigin() == null ^ this.getOrigin() == null) {
            return false;
        }
        if (other.getOrigin() != null && !other.getOrigin().equals(this.getOrigin())) {
            return false;
        }
        if (other.getDefaultCacheBehavior() == null ^ this.getDefaultCacheBehavior() == null) {
            return false;
        }
        if (other.getDefaultCacheBehavior() != null && !other.getDefaultCacheBehavior().equals(this.getDefaultCacheBehavior())) {
            return false;
        }
        if (other.getCacheBehaviorSettings() == null ^ this.getCacheBehaviorSettings() == null) {
            return false;
        }
        if (other.getCacheBehaviorSettings() != null && !other.getCacheBehaviorSettings().equals(this.getCacheBehaviorSettings())) {
            return false;
        }
        if (other.getCacheBehaviors() == null ^ this.getCacheBehaviors() == null) {
            return false;
        }
        if (other.getCacheBehaviors() != null && !other.getCacheBehaviors().equals(this.getCacheBehaviors())) {
            return false;
        }
        if (other.getIsEnabled() == null ^ this.getIsEnabled() == null) {
            return false;
        }
        if (other.getIsEnabled() != null && !other.getIsEnabled().equals(this.getIsEnabled())) {
            return false;
        }
        if (other.getViewerMinimumTlsProtocolVersion() == null ^ this.getViewerMinimumTlsProtocolVersion() == null) {
            return false;
        }
        if (other.getViewerMinimumTlsProtocolVersion() != null && !other.getViewerMinimumTlsProtocolVersion().equals(this.getViewerMinimumTlsProtocolVersion())) {
            return false;
        }
        if (other.getCertificateName() == null ^ this.getCertificateName() == null) {
            return false;
        }
        if (other.getCertificateName() != null && !other.getCertificateName().equals(this.getCertificateName())) {
            return false;
        }
        if (other.getUseDefaultCertificate() == null ^ this.getUseDefaultCertificate() == null) {
            return false;
        }
        return other.getUseDefaultCertificate() == null || other.getUseDefaultCertificate().equals(this.getUseDefaultCertificate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDistributionName() == null ? 0 : this.getDistributionName().hashCode());
        hashCode = 31 * hashCode + (this.getOrigin() == null ? 0 : this.getOrigin().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCacheBehavior() == null ? 0 : this.getDefaultCacheBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getCacheBehaviorSettings() == null ? 0 : this.getCacheBehaviorSettings().hashCode());
        hashCode = 31 * hashCode + (this.getCacheBehaviors() == null ? 0 : this.getCacheBehaviors().hashCode());
        hashCode = 31 * hashCode + (this.getIsEnabled() == null ? 0 : this.getIsEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getViewerMinimumTlsProtocolVersion() == null ? 0 : this.getViewerMinimumTlsProtocolVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateName() == null ? 0 : this.getCertificateName().hashCode());
        hashCode = 31 * hashCode + (this.getUseDefaultCertificate() == null ? 0 : this.getUseDefaultCertificate().hashCode());
        return hashCode;
    }

    public UpdateDistributionRequest clone() {
        return (UpdateDistributionRequest)super.clone();
    }
}

