/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.HostKeyAttributes;
import com.amazonaws.services.lightsail.model.InstanceAccessProtocol;
import com.amazonaws.services.lightsail.model.PasswordData;
import com.amazonaws.services.lightsail.model.transform.InstanceAccessDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class InstanceAccessDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String certKey;
    private Date expiresAt;
    private String ipAddress;
    private List<String> ipv6Addresses;
    private String password;
    private PasswordData passwordData;
    private String privateKey;
    private String protocol;
    private String instanceName;
    private String username;
    private List<HostKeyAttributes> hostKeys;

    public void setCertKey(String certKey) {
        this.certKey = certKey;
    }

    public String getCertKey() {
        return this.certKey;
    }

    public InstanceAccessDetails withCertKey(String certKey) {
        this.setCertKey(certKey);
        return this;
    }

    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public InstanceAccessDetails withExpiresAt(Date expiresAt) {
        this.setExpiresAt(expiresAt);
        return this;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public InstanceAccessDetails withIpAddress(String ipAddress) {
        this.setIpAddress(ipAddress);
        return this;
    }

    public List<String> getIpv6Addresses() {
        return this.ipv6Addresses;
    }

    public void setIpv6Addresses(Collection<String> ipv6Addresses) {
        if (ipv6Addresses == null) {
            this.ipv6Addresses = null;
            return;
        }
        this.ipv6Addresses = new ArrayList<String>(ipv6Addresses);
    }

    public InstanceAccessDetails withIpv6Addresses(String ... ipv6Addresses) {
        if (this.ipv6Addresses == null) {
            this.setIpv6Addresses(new ArrayList<String>(ipv6Addresses.length));
        }
        for (String ele : ipv6Addresses) {
            this.ipv6Addresses.add(ele);
        }
        return this;
    }

    public InstanceAccessDetails withIpv6Addresses(Collection<String> ipv6Addresses) {
        this.setIpv6Addresses(ipv6Addresses);
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public InstanceAccessDetails withPassword(String password) {
        this.setPassword(password);
        return this;
    }

    public void setPasswordData(PasswordData passwordData) {
        this.passwordData = passwordData;
    }

    public PasswordData getPasswordData() {
        return this.passwordData;
    }

    public InstanceAccessDetails withPasswordData(PasswordData passwordData) {
        this.setPasswordData(passwordData);
        return this;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public InstanceAccessDetails withPrivateKey(String privateKey) {
        this.setPrivateKey(privateKey);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public InstanceAccessDetails withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setProtocol(InstanceAccessProtocol protocol) {
        this.withProtocol(protocol);
    }

    public InstanceAccessDetails withProtocol(InstanceAccessProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public InstanceAccessDetails withInstanceName(String instanceName) {
        this.setInstanceName(instanceName);
        return this;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public InstanceAccessDetails withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public List<HostKeyAttributes> getHostKeys() {
        return this.hostKeys;
    }

    public void setHostKeys(Collection<HostKeyAttributes> hostKeys) {
        if (hostKeys == null) {
            this.hostKeys = null;
            return;
        }
        this.hostKeys = new ArrayList<HostKeyAttributes>(hostKeys);
    }

    public InstanceAccessDetails withHostKeys(HostKeyAttributes ... hostKeys) {
        if (this.hostKeys == null) {
            this.setHostKeys(new ArrayList<HostKeyAttributes>(hostKeys.length));
        }
        for (HostKeyAttributes ele : hostKeys) {
            this.hostKeys.add(ele);
        }
        return this;
    }

    public InstanceAccessDetails withHostKeys(Collection<HostKeyAttributes> hostKeys) {
        this.setHostKeys(hostKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertKey() != null) {
            sb.append("CertKey: ").append(this.getCertKey()).append(",");
        }
        if (this.getExpiresAt() != null) {
            sb.append("ExpiresAt: ").append(this.getExpiresAt()).append(",");
        }
        if (this.getIpAddress() != null) {
            sb.append("IpAddress: ").append(this.getIpAddress()).append(",");
        }
        if (this.getIpv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.getIpv6Addresses()).append(",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: ").append(this.getPassword()).append(",");
        }
        if (this.getPasswordData() != null) {
            sb.append("PasswordData: ").append(this.getPasswordData()).append(",");
        }
        if (this.getPrivateKey() != null) {
            sb.append("PrivateKey: ").append(this.getPrivateKey()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getInstanceName() != null) {
            sb.append("InstanceName: ").append(this.getInstanceName()).append(",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername()).append(",");
        }
        if (this.getHostKeys() != null) {
            sb.append("HostKeys: ").append(this.getHostKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAccessDetails)) {
            return false;
        }
        InstanceAccessDetails other = (InstanceAccessDetails)obj;
        if (other.getCertKey() == null ^ this.getCertKey() == null) {
            return false;
        }
        if (other.getCertKey() != null && !other.getCertKey().equals(this.getCertKey())) {
            return false;
        }
        if (other.getExpiresAt() == null ^ this.getExpiresAt() == null) {
            return false;
        }
        if (other.getExpiresAt() != null && !other.getExpiresAt().equals(this.getExpiresAt())) {
            return false;
        }
        if (other.getIpAddress() == null ^ this.getIpAddress() == null) {
            return false;
        }
        if (other.getIpAddress() != null && !other.getIpAddress().equals(this.getIpAddress())) {
            return false;
        }
        if (other.getIpv6Addresses() == null ^ this.getIpv6Addresses() == null) {
            return false;
        }
        if (other.getIpv6Addresses() != null && !other.getIpv6Addresses().equals(this.getIpv6Addresses())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getPasswordData() == null ^ this.getPasswordData() == null) {
            return false;
        }
        if (other.getPasswordData() != null && !other.getPasswordData().equals(this.getPasswordData())) {
            return false;
        }
        if (other.getPrivateKey() == null ^ this.getPrivateKey() == null) {
            return false;
        }
        if (other.getPrivateKey() != null && !other.getPrivateKey().equals(this.getPrivateKey())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getInstanceName() == null ^ this.getInstanceName() == null) {
            return false;
        }
        if (other.getInstanceName() != null && !other.getInstanceName().equals(this.getInstanceName())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getHostKeys() == null ^ this.getHostKeys() == null) {
            return false;
        }
        return other.getHostKeys() == null || other.getHostKeys().equals(this.getHostKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertKey() == null ? 0 : this.getCertKey().hashCode());
        hashCode = 31 * hashCode + (this.getExpiresAt() == null ? 0 : this.getExpiresAt().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddress() == null ? 0 : this.getIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6Addresses() == null ? 0 : this.getIpv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getPasswordData() == null ? 0 : this.getPasswordData().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateKey() == null ? 0 : this.getPrivateKey().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceName() == null ? 0 : this.getInstanceName().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getHostKeys() == null ? 0 : this.getHostKeys().hashCode());
        return hashCode;
    }

    public InstanceAccessDetails clone() {
        try {
            return (InstanceAccessDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAccessDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

