/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.ResourceRecord;

@SdkInternalApi
public class ResourceRecordMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").build();
    private static final ResourceRecordMarshaller instance = new ResourceRecordMarshaller();

    public static ResourceRecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceRecord resourceRecord, ProtocolMarshaller protocolMarshaller) {
        if (resourceRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceRecord.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)resourceRecord.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceRecord.getValue(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

