/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.ContainerServiceDeployment;
import com.amazonaws.services.lightsail.model.ContainerServicePowerName;
import com.amazonaws.services.lightsail.model.ContainerServiceState;
import com.amazonaws.services.lightsail.model.ContainerServiceStateDetail;
import com.amazonaws.services.lightsail.model.PrivateRegistryAccess;
import com.amazonaws.services.lightsail.model.ResourceLocation;
import com.amazonaws.services.lightsail.model.ResourceType;
import com.amazonaws.services.lightsail.model.Tag;
import com.amazonaws.services.lightsail.model.transform.ContainerServiceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerService
implements Serializable,
Cloneable,
StructuredPojo {
    private String containerServiceName;
    private String arn;
    private Date createdAt;
    private ResourceLocation location;
    private String resourceType;
    private List<Tag> tags;
    private String power;
    private String powerId;
    private String state;
    private ContainerServiceStateDetail stateDetail;
    private Integer scale;
    private ContainerServiceDeployment currentDeployment;
    private ContainerServiceDeployment nextDeployment;
    private Boolean isDisabled;
    private String principalArn;
    private String privateDomainName;
    private Map<String, List<String>> publicDomainNames;
    private String url;
    private PrivateRegistryAccess privateRegistryAccess;

    public void setContainerServiceName(String containerServiceName) {
        this.containerServiceName = containerServiceName;
    }

    public String getContainerServiceName() {
        return this.containerServiceName;
    }

    public ContainerService withContainerServiceName(String containerServiceName) {
        this.setContainerServiceName(containerServiceName);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ContainerService withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public ContainerService withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public ContainerService withLocation(ResourceLocation location) {
        this.setLocation(location);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ContainerService withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public ContainerService withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ContainerService withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ContainerService withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setPower(String power) {
        this.power = power;
    }

    public String getPower() {
        return this.power;
    }

    public ContainerService withPower(String power) {
        this.setPower(power);
        return this;
    }

    public ContainerService withPower(ContainerServicePowerName power) {
        this.power = power.toString();
        return this;
    }

    public void setPowerId(String powerId) {
        this.powerId = powerId;
    }

    public String getPowerId() {
        return this.powerId;
    }

    public ContainerService withPowerId(String powerId) {
        this.setPowerId(powerId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public ContainerService withState(String state) {
        this.setState(state);
        return this;
    }

    public ContainerService withState(ContainerServiceState state) {
        this.state = state.toString();
        return this;
    }

    public void setStateDetail(ContainerServiceStateDetail stateDetail) {
        this.stateDetail = stateDetail;
    }

    public ContainerServiceStateDetail getStateDetail() {
        return this.stateDetail;
    }

    public ContainerService withStateDetail(ContainerServiceStateDetail stateDetail) {
        this.setStateDetail(stateDetail);
        return this;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Integer getScale() {
        return this.scale;
    }

    public ContainerService withScale(Integer scale) {
        this.setScale(scale);
        return this;
    }

    public void setCurrentDeployment(ContainerServiceDeployment currentDeployment) {
        this.currentDeployment = currentDeployment;
    }

    public ContainerServiceDeployment getCurrentDeployment() {
        return this.currentDeployment;
    }

    public ContainerService withCurrentDeployment(ContainerServiceDeployment currentDeployment) {
        this.setCurrentDeployment(currentDeployment);
        return this;
    }

    public void setNextDeployment(ContainerServiceDeployment nextDeployment) {
        this.nextDeployment = nextDeployment;
    }

    public ContainerServiceDeployment getNextDeployment() {
        return this.nextDeployment;
    }

    public ContainerService withNextDeployment(ContainerServiceDeployment nextDeployment) {
        this.setNextDeployment(nextDeployment);
        return this;
    }

    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    public ContainerService withIsDisabled(Boolean isDisabled) {
        this.setIsDisabled(isDisabled);
        return this;
    }

    public Boolean isDisabled() {
        return this.isDisabled;
    }

    public void setPrincipalArn(String principalArn) {
        this.principalArn = principalArn;
    }

    public String getPrincipalArn() {
        return this.principalArn;
    }

    public ContainerService withPrincipalArn(String principalArn) {
        this.setPrincipalArn(principalArn);
        return this;
    }

    public void setPrivateDomainName(String privateDomainName) {
        this.privateDomainName = privateDomainName;
    }

    public String getPrivateDomainName() {
        return this.privateDomainName;
    }

    public ContainerService withPrivateDomainName(String privateDomainName) {
        this.setPrivateDomainName(privateDomainName);
        return this;
    }

    public Map<String, List<String>> getPublicDomainNames() {
        return this.publicDomainNames;
    }

    public void setPublicDomainNames(Map<String, List<String>> publicDomainNames) {
        this.publicDomainNames = publicDomainNames;
    }

    public ContainerService withPublicDomainNames(Map<String, List<String>> publicDomainNames) {
        this.setPublicDomainNames(publicDomainNames);
        return this;
    }

    public ContainerService addPublicDomainNamesEntry(String key, List<String> value) {
        if (null == this.publicDomainNames) {
            this.publicDomainNames = new HashMap<String, List<String>>();
        }
        if (this.publicDomainNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.publicDomainNames.put(key, value);
        return this;
    }

    public ContainerService clearPublicDomainNamesEntries() {
        this.publicDomainNames = null;
        return this;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public ContainerService withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public void setPrivateRegistryAccess(PrivateRegistryAccess privateRegistryAccess) {
        this.privateRegistryAccess = privateRegistryAccess;
    }

    public PrivateRegistryAccess getPrivateRegistryAccess() {
        return this.privateRegistryAccess;
    }

    public ContainerService withPrivateRegistryAccess(PrivateRegistryAccess privateRegistryAccess) {
        this.setPrivateRegistryAccess(privateRegistryAccess);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerServiceName() != null) {
            sb.append("ContainerServiceName: ").append(this.getContainerServiceName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getPower() != null) {
            sb.append("Power: ").append(this.getPower()).append(",");
        }
        if (this.getPowerId() != null) {
            sb.append("PowerId: ").append(this.getPowerId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStateDetail() != null) {
            sb.append("StateDetail: ").append(this.getStateDetail()).append(",");
        }
        if (this.getScale() != null) {
            sb.append("Scale: ").append(this.getScale()).append(",");
        }
        if (this.getCurrentDeployment() != null) {
            sb.append("CurrentDeployment: ").append(this.getCurrentDeployment()).append(",");
        }
        if (this.getNextDeployment() != null) {
            sb.append("NextDeployment: ").append(this.getNextDeployment()).append(",");
        }
        if (this.getIsDisabled() != null) {
            sb.append("IsDisabled: ").append(this.getIsDisabled()).append(",");
        }
        if (this.getPrincipalArn() != null) {
            sb.append("PrincipalArn: ").append(this.getPrincipalArn()).append(",");
        }
        if (this.getPrivateDomainName() != null) {
            sb.append("PrivateDomainName: ").append(this.getPrivateDomainName()).append(",");
        }
        if (this.getPublicDomainNames() != null) {
            sb.append("PublicDomainNames: ").append(this.getPublicDomainNames()).append(",");
        }
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl()).append(",");
        }
        if (this.getPrivateRegistryAccess() != null) {
            sb.append("PrivateRegistryAccess: ").append(this.getPrivateRegistryAccess());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerService)) {
            return false;
        }
        ContainerService other = (ContainerService)obj;
        if (other.getContainerServiceName() == null ^ this.getContainerServiceName() == null) {
            return false;
        }
        if (other.getContainerServiceName() != null && !other.getContainerServiceName().equals(this.getContainerServiceName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPower() == null ^ this.getPower() == null) {
            return false;
        }
        if (other.getPower() != null && !other.getPower().equals(this.getPower())) {
            return false;
        }
        if (other.getPowerId() == null ^ this.getPowerId() == null) {
            return false;
        }
        if (other.getPowerId() != null && !other.getPowerId().equals(this.getPowerId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStateDetail() == null ^ this.getStateDetail() == null) {
            return false;
        }
        if (other.getStateDetail() != null && !other.getStateDetail().equals(this.getStateDetail())) {
            return false;
        }
        if (other.getScale() == null ^ this.getScale() == null) {
            return false;
        }
        if (other.getScale() != null && !other.getScale().equals(this.getScale())) {
            return false;
        }
        if (other.getCurrentDeployment() == null ^ this.getCurrentDeployment() == null) {
            return false;
        }
        if (other.getCurrentDeployment() != null && !other.getCurrentDeployment().equals(this.getCurrentDeployment())) {
            return false;
        }
        if (other.getNextDeployment() == null ^ this.getNextDeployment() == null) {
            return false;
        }
        if (other.getNextDeployment() != null && !other.getNextDeployment().equals(this.getNextDeployment())) {
            return false;
        }
        if (other.getIsDisabled() == null ^ this.getIsDisabled() == null) {
            return false;
        }
        if (other.getIsDisabled() != null && !other.getIsDisabled().equals(this.getIsDisabled())) {
            return false;
        }
        if (other.getPrincipalArn() == null ^ this.getPrincipalArn() == null) {
            return false;
        }
        if (other.getPrincipalArn() != null && !other.getPrincipalArn().equals(this.getPrincipalArn())) {
            return false;
        }
        if (other.getPrivateDomainName() == null ^ this.getPrivateDomainName() == null) {
            return false;
        }
        if (other.getPrivateDomainName() != null && !other.getPrivateDomainName().equals(this.getPrivateDomainName())) {
            return false;
        }
        if (other.getPublicDomainNames() == null ^ this.getPublicDomainNames() == null) {
            return false;
        }
        if (other.getPublicDomainNames() != null && !other.getPublicDomainNames().equals(this.getPublicDomainNames())) {
            return false;
        }
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        if (other.getUrl() != null && !other.getUrl().equals(this.getUrl())) {
            return false;
        }
        if (other.getPrivateRegistryAccess() == null ^ this.getPrivateRegistryAccess() == null) {
            return false;
        }
        return other.getPrivateRegistryAccess() == null || other.getPrivateRegistryAccess().equals(this.getPrivateRegistryAccess());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerServiceName() == null ? 0 : this.getContainerServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPower() == null ? 0 : this.getPower().hashCode());
        hashCode = 31 * hashCode + (this.getPowerId() == null ? 0 : this.getPowerId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStateDetail() == null ? 0 : this.getStateDetail().hashCode());
        hashCode = 31 * hashCode + (this.getScale() == null ? 0 : this.getScale().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentDeployment() == null ? 0 : this.getCurrentDeployment().hashCode());
        hashCode = 31 * hashCode + (this.getNextDeployment() == null ? 0 : this.getNextDeployment().hashCode());
        hashCode = 31 * hashCode + (this.getIsDisabled() == null ? 0 : this.getIsDisabled().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipalArn() == null ? 0 : this.getPrincipalArn().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDomainName() == null ? 0 : this.getPrivateDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getPublicDomainNames() == null ? 0 : this.getPublicDomainNames().hashCode());
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateRegistryAccess() == null ? 0 : this.getPrivateRegistryAccess().hashCode());
        return hashCode;
    }

    public ContainerService clone() {
        try {
            return (ContainerService)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

