/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.CostEstimate;
import com.amazonaws.services.lightsail.model.ResourceType;
import com.amazonaws.services.lightsail.model.transform.ResourceBudgetEstimateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ResourceBudgetEstimate
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceName;
    private String resourceType;
    private List<CostEstimate> costEstimates;
    private Date startTime;
    private Date endTime;

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ResourceBudgetEstimate withResourceName(String resourceName) {
        this.setResourceName(resourceName);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceBudgetEstimate withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public ResourceBudgetEstimate withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<CostEstimate> getCostEstimates() {
        return this.costEstimates;
    }

    public void setCostEstimates(Collection<CostEstimate> costEstimates) {
        if (costEstimates == null) {
            this.costEstimates = null;
            return;
        }
        this.costEstimates = new ArrayList<CostEstimate>(costEstimates);
    }

    public ResourceBudgetEstimate withCostEstimates(CostEstimate ... costEstimates) {
        if (this.costEstimates == null) {
            this.setCostEstimates(new ArrayList<CostEstimate>(costEstimates.length));
        }
        for (CostEstimate ele : costEstimates) {
            this.costEstimates.add(ele);
        }
        return this;
    }

    public ResourceBudgetEstimate withCostEstimates(Collection<CostEstimate> costEstimates) {
        this.setCostEstimates(costEstimates);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public ResourceBudgetEstimate withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public ResourceBudgetEstimate withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceName() != null) {
            sb.append("ResourceName: ").append(this.getResourceName()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getCostEstimates() != null) {
            sb.append("CostEstimates: ").append(this.getCostEstimates()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceBudgetEstimate)) {
            return false;
        }
        ResourceBudgetEstimate other = (ResourceBudgetEstimate)obj;
        if (other.getResourceName() == null ^ this.getResourceName() == null) {
            return false;
        }
        if (other.getResourceName() != null && !other.getResourceName().equals(this.getResourceName())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getCostEstimates() == null ^ this.getCostEstimates() == null) {
            return false;
        }
        if (other.getCostEstimates() != null && !other.getCostEstimates().equals(this.getCostEstimates())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        return other.getEndTime() == null || other.getEndTime().equals(this.getEndTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceName() == null ? 0 : this.getResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getCostEstimates() == null ? 0 : this.getCostEstimates().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        return hashCode;
    }

    public ResourceBudgetEstimate clone() {
        try {
            return (ResourceBudgetEstimate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceBudgetEstimateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

