/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.CertificateStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetCertificatesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> certificateStatuses;
    private Boolean includeCertificateDetails;
    private String certificateName;

    public List<String> getCertificateStatuses() {
        return this.certificateStatuses;
    }

    public void setCertificateStatuses(Collection<String> certificateStatuses) {
        if (certificateStatuses == null) {
            this.certificateStatuses = null;
            return;
        }
        this.certificateStatuses = new ArrayList<String>(certificateStatuses);
    }

    public GetCertificatesRequest withCertificateStatuses(String ... certificateStatuses) {
        if (this.certificateStatuses == null) {
            this.setCertificateStatuses(new ArrayList<String>(certificateStatuses.length));
        }
        for (String ele : certificateStatuses) {
            this.certificateStatuses.add(ele);
        }
        return this;
    }

    public GetCertificatesRequest withCertificateStatuses(Collection<String> certificateStatuses) {
        this.setCertificateStatuses(certificateStatuses);
        return this;
    }

    public GetCertificatesRequest withCertificateStatuses(CertificateStatus ... certificateStatuses) {
        ArrayList<String> certificateStatusesCopy = new ArrayList<String>(certificateStatuses.length);
        for (CertificateStatus value : certificateStatuses) {
            certificateStatusesCopy.add(value.toString());
        }
        if (this.getCertificateStatuses() == null) {
            this.setCertificateStatuses(certificateStatusesCopy);
        } else {
            this.getCertificateStatuses().addAll(certificateStatusesCopy);
        }
        return this;
    }

    public void setIncludeCertificateDetails(Boolean includeCertificateDetails) {
        this.includeCertificateDetails = includeCertificateDetails;
    }

    public Boolean getIncludeCertificateDetails() {
        return this.includeCertificateDetails;
    }

    public GetCertificatesRequest withIncludeCertificateDetails(Boolean includeCertificateDetails) {
        this.setIncludeCertificateDetails(includeCertificateDetails);
        return this;
    }

    public Boolean isIncludeCertificateDetails() {
        return this.includeCertificateDetails;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public GetCertificatesRequest withCertificateName(String certificateName) {
        this.setCertificateName(certificateName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateStatuses() != null) {
            sb.append("CertificateStatuses: ").append(this.getCertificateStatuses()).append(",");
        }
        if (this.getIncludeCertificateDetails() != null) {
            sb.append("IncludeCertificateDetails: ").append(this.getIncludeCertificateDetails()).append(",");
        }
        if (this.getCertificateName() != null) {
            sb.append("CertificateName: ").append(this.getCertificateName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificatesRequest)) {
            return false;
        }
        GetCertificatesRequest other = (GetCertificatesRequest)obj;
        if (other.getCertificateStatuses() == null ^ this.getCertificateStatuses() == null) {
            return false;
        }
        if (other.getCertificateStatuses() != null && !other.getCertificateStatuses().equals(this.getCertificateStatuses())) {
            return false;
        }
        if (other.getIncludeCertificateDetails() == null ^ this.getIncludeCertificateDetails() == null) {
            return false;
        }
        if (other.getIncludeCertificateDetails() != null && !other.getIncludeCertificateDetails().equals(this.getIncludeCertificateDetails())) {
            return false;
        }
        if (other.getCertificateName() == null ^ this.getCertificateName() == null) {
            return false;
        }
        return other.getCertificateName() == null || other.getCertificateName().equals(this.getCertificateName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateStatuses() == null ? 0 : this.getCertificateStatuses().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeCertificateDetails() == null ? 0 : this.getIncludeCertificateDetails().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateName() == null ? 0 : this.getCertificateName().hashCode());
        return hashCode;
    }

    public GetCertificatesRequest clone() {
        return (GetCertificatesRequest)super.clone();
    }
}

