/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.DomainValidationRecord;
import com.amazonaws.services.lightsail.model.RenewalStatus;
import com.amazonaws.services.lightsail.model.transform.RenewalSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RenewalSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DomainValidationRecord> domainValidationRecords;
    private String renewalStatus;
    private String renewalStatusReason;
    private Date updatedAt;

    public List<DomainValidationRecord> getDomainValidationRecords() {
        return this.domainValidationRecords;
    }

    public void setDomainValidationRecords(Collection<DomainValidationRecord> domainValidationRecords) {
        if (domainValidationRecords == null) {
            this.domainValidationRecords = null;
            return;
        }
        this.domainValidationRecords = new ArrayList<DomainValidationRecord>(domainValidationRecords);
    }

    public RenewalSummary withDomainValidationRecords(DomainValidationRecord ... domainValidationRecords) {
        if (this.domainValidationRecords == null) {
            this.setDomainValidationRecords(new ArrayList<DomainValidationRecord>(domainValidationRecords.length));
        }
        for (DomainValidationRecord ele : domainValidationRecords) {
            this.domainValidationRecords.add(ele);
        }
        return this;
    }

    public RenewalSummary withDomainValidationRecords(Collection<DomainValidationRecord> domainValidationRecords) {
        this.setDomainValidationRecords(domainValidationRecords);
        return this;
    }

    public void setRenewalStatus(String renewalStatus) {
        this.renewalStatus = renewalStatus;
    }

    public String getRenewalStatus() {
        return this.renewalStatus;
    }

    public RenewalSummary withRenewalStatus(String renewalStatus) {
        this.setRenewalStatus(renewalStatus);
        return this;
    }

    public RenewalSummary withRenewalStatus(RenewalStatus renewalStatus) {
        this.renewalStatus = renewalStatus.toString();
        return this;
    }

    public void setRenewalStatusReason(String renewalStatusReason) {
        this.renewalStatusReason = renewalStatusReason;
    }

    public String getRenewalStatusReason() {
        return this.renewalStatusReason;
    }

    public RenewalSummary withRenewalStatusReason(String renewalStatusReason) {
        this.setRenewalStatusReason(renewalStatusReason);
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public RenewalSummary withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainValidationRecords() != null) {
            sb.append("DomainValidationRecords: ").append(this.getDomainValidationRecords()).append(",");
        }
        if (this.getRenewalStatus() != null) {
            sb.append("RenewalStatus: ").append(this.getRenewalStatus()).append(",");
        }
        if (this.getRenewalStatusReason() != null) {
            sb.append("RenewalStatusReason: ").append(this.getRenewalStatusReason()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalSummary)) {
            return false;
        }
        RenewalSummary other = (RenewalSummary)obj;
        if (other.getDomainValidationRecords() == null ^ this.getDomainValidationRecords() == null) {
            return false;
        }
        if (other.getDomainValidationRecords() != null && !other.getDomainValidationRecords().equals(this.getDomainValidationRecords())) {
            return false;
        }
        if (other.getRenewalStatus() == null ^ this.getRenewalStatus() == null) {
            return false;
        }
        if (other.getRenewalStatus() != null && !other.getRenewalStatus().equals(this.getRenewalStatus())) {
            return false;
        }
        if (other.getRenewalStatusReason() == null ^ this.getRenewalStatusReason() == null) {
            return false;
        }
        if (other.getRenewalStatusReason() != null && !other.getRenewalStatusReason().equals(this.getRenewalStatusReason())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        return other.getUpdatedAt() == null || other.getUpdatedAt().equals(this.getUpdatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainValidationRecords() == null ? 0 : this.getDomainValidationRecords().hashCode());
        hashCode = 31 * hashCode + (this.getRenewalStatus() == null ? 0 : this.getRenewalStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRenewalStatusReason() == null ? 0 : this.getRenewalStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        return hashCode;
    }

    public RenewalSummary clone() {
        try {
            return (RenewalSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RenewalSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

