/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.CloudFormationStackRecord;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class CloudFormationStackRecordMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<List> SOURCEINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceInfo").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationInfo").build();
    private static final CloudFormationStackRecordMarshaller instance = new CloudFormationStackRecordMarshaller();

    public static CloudFormationStackRecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudFormationStackRecord cloudFormationStackRecord, ProtocolMarshaller protocolMarshaller) {
        if (cloudFormationStackRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudFormationStackRecord.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)cloudFormationStackRecord.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)cloudFormationStackRecord.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)cloudFormationStackRecord.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)cloudFormationStackRecord.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)cloudFormationStackRecord.getState(), STATE_BINDING);
            protocolMarshaller.marshall(cloudFormationStackRecord.getSourceInfo(), SOURCEINFO_BINDING);
            protocolMarshaller.marshall((Object)cloudFormationStackRecord.getDestinationInfo(), DESTINATIONINFO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

