/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.AccessDirection;
import com.amazonaws.services.lightsail.model.NetworkProtocol;
import com.amazonaws.services.lightsail.model.PortAccessType;
import com.amazonaws.services.lightsail.model.transform.InstancePortInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstancePortInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer fromPort;
    private Integer toPort;
    private String protocol;
    private String accessFrom;
    private String accessType;
    private String commonName;
    private String accessDirection;
    private List<String> cidrs;
    private List<String> cidrListAliases;

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public InstancePortInfo withFromPort(Integer fromPort) {
        this.setFromPort(fromPort);
        return this;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public InstancePortInfo withToPort(Integer toPort) {
        this.setToPort(toPort);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public InstancePortInfo withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setProtocol(NetworkProtocol protocol) {
        this.withProtocol(protocol);
    }

    public InstancePortInfo withProtocol(NetworkProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setAccessFrom(String accessFrom) {
        this.accessFrom = accessFrom;
    }

    public String getAccessFrom() {
        return this.accessFrom;
    }

    public InstancePortInfo withAccessFrom(String accessFrom) {
        this.setAccessFrom(accessFrom);
        return this;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public InstancePortInfo withAccessType(String accessType) {
        this.setAccessType(accessType);
        return this;
    }

    public void setAccessType(PortAccessType accessType) {
        this.withAccessType(accessType);
    }

    public InstancePortInfo withAccessType(PortAccessType accessType) {
        this.accessType = accessType.toString();
        return this;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public InstancePortInfo withCommonName(String commonName) {
        this.setCommonName(commonName);
        return this;
    }

    public void setAccessDirection(String accessDirection) {
        this.accessDirection = accessDirection;
    }

    public String getAccessDirection() {
        return this.accessDirection;
    }

    public InstancePortInfo withAccessDirection(String accessDirection) {
        this.setAccessDirection(accessDirection);
        return this;
    }

    public void setAccessDirection(AccessDirection accessDirection) {
        this.withAccessDirection(accessDirection);
    }

    public InstancePortInfo withAccessDirection(AccessDirection accessDirection) {
        this.accessDirection = accessDirection.toString();
        return this;
    }

    public List<String> getCidrs() {
        return this.cidrs;
    }

    public void setCidrs(Collection<String> cidrs) {
        if (cidrs == null) {
            this.cidrs = null;
            return;
        }
        this.cidrs = new ArrayList<String>(cidrs);
    }

    public InstancePortInfo withCidrs(String ... cidrs) {
        if (this.cidrs == null) {
            this.setCidrs(new ArrayList<String>(cidrs.length));
        }
        for (String ele : cidrs) {
            this.cidrs.add(ele);
        }
        return this;
    }

    public InstancePortInfo withCidrs(Collection<String> cidrs) {
        this.setCidrs(cidrs);
        return this;
    }

    public List<String> getCidrListAliases() {
        return this.cidrListAliases;
    }

    public void setCidrListAliases(Collection<String> cidrListAliases) {
        if (cidrListAliases == null) {
            this.cidrListAliases = null;
            return;
        }
        this.cidrListAliases = new ArrayList<String>(cidrListAliases);
    }

    public InstancePortInfo withCidrListAliases(String ... cidrListAliases) {
        if (this.cidrListAliases == null) {
            this.setCidrListAliases(new ArrayList<String>(cidrListAliases.length));
        }
        for (String ele : cidrListAliases) {
            this.cidrListAliases.add(ele);
        }
        return this;
    }

    public InstancePortInfo withCidrListAliases(Collection<String> cidrListAliases) {
        this.setCidrListAliases(cidrListAliases);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFromPort() != null) {
            sb.append("FromPort: ").append(this.getFromPort()).append(",");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: ").append(this.getToPort()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getAccessFrom() != null) {
            sb.append("AccessFrom: ").append(this.getAccessFrom()).append(",");
        }
        if (this.getAccessType() != null) {
            sb.append("AccessType: ").append(this.getAccessType()).append(",");
        }
        if (this.getCommonName() != null) {
            sb.append("CommonName: ").append(this.getCommonName()).append(",");
        }
        if (this.getAccessDirection() != null) {
            sb.append("AccessDirection: ").append(this.getAccessDirection()).append(",");
        }
        if (this.getCidrs() != null) {
            sb.append("Cidrs: ").append(this.getCidrs()).append(",");
        }
        if (this.getCidrListAliases() != null) {
            sb.append("CidrListAliases: ").append(this.getCidrListAliases());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePortInfo)) {
            return false;
        }
        InstancePortInfo other = (InstancePortInfo)obj;
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        if (other.getToPort() != null && !other.getToPort().equals(this.getToPort())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getAccessFrom() == null ^ this.getAccessFrom() == null) {
            return false;
        }
        if (other.getAccessFrom() != null && !other.getAccessFrom().equals(this.getAccessFrom())) {
            return false;
        }
        if (other.getAccessType() == null ^ this.getAccessType() == null) {
            return false;
        }
        if (other.getAccessType() != null && !other.getAccessType().equals(this.getAccessType())) {
            return false;
        }
        if (other.getCommonName() == null ^ this.getCommonName() == null) {
            return false;
        }
        if (other.getCommonName() != null && !other.getCommonName().equals(this.getCommonName())) {
            return false;
        }
        if (other.getAccessDirection() == null ^ this.getAccessDirection() == null) {
            return false;
        }
        if (other.getAccessDirection() != null && !other.getAccessDirection().equals(this.getAccessDirection())) {
            return false;
        }
        if (other.getCidrs() == null ^ this.getCidrs() == null) {
            return false;
        }
        if (other.getCidrs() != null && !other.getCidrs().equals(this.getCidrs())) {
            return false;
        }
        if (other.getCidrListAliases() == null ^ this.getCidrListAliases() == null) {
            return false;
        }
        return other.getCidrListAliases() == null || other.getCidrListAliases().equals(this.getCidrListAliases());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getAccessFrom() == null ? 0 : this.getAccessFrom().hashCode());
        hashCode = 31 * hashCode + (this.getAccessType() == null ? 0 : this.getAccessType().hashCode());
        hashCode = 31 * hashCode + (this.getCommonName() == null ? 0 : this.getCommonName().hashCode());
        hashCode = 31 * hashCode + (this.getAccessDirection() == null ? 0 : this.getAccessDirection().hashCode());
        hashCode = 31 * hashCode + (this.getCidrs() == null ? 0 : this.getCidrs().hashCode());
        hashCode = 31 * hashCode + (this.getCidrListAliases() == null ? 0 : this.getCidrListAliases().hashCode());
        return hashCode;
    }

    public InstancePortInfo clone() {
        try {
            return (InstancePortInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePortInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

