/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.StaticIp;
import com.amazonaws.services.lightsail.model.transform.ResourceLocationJsonMarshaller;

public class StaticIpJsonMarshaller {
    private static StaticIpJsonMarshaller instance;

    public void marshall(StaticIp staticIp, StructuredJsonGenerator jsonGenerator) {
        if (staticIp == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (staticIp.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(staticIp.getName());
            }
            if (staticIp.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(staticIp.getArn());
            }
            if (staticIp.getSupportCode() != null) {
                jsonGenerator.writeFieldName("supportCode").writeValue(staticIp.getSupportCode());
            }
            if (staticIp.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(staticIp.getCreatedAt());
            }
            if (staticIp.getLocation() != null) {
                jsonGenerator.writeFieldName("location");
                ResourceLocationJsonMarshaller.getInstance().marshall(staticIp.getLocation(), jsonGenerator);
            }
            if (staticIp.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(staticIp.getResourceType());
            }
            if (staticIp.getIpAddress() != null) {
                jsonGenerator.writeFieldName("ipAddress").writeValue(staticIp.getIpAddress());
            }
            if (staticIp.getAttachedTo() != null) {
                jsonGenerator.writeFieldName("attachedTo").writeValue(staticIp.getAttachedTo());
            }
            if (staticIp.getIsAttached() != null) {
                jsonGenerator.writeFieldName("isAttached").writeValue(staticIp.getIsAttached().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StaticIpJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StaticIpJsonMarshaller();
        }
        return instance;
    }
}

