/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.DomainEntry;
import java.util.Map;

public class DomainEntryJsonMarshaller {
    private static DomainEntryJsonMarshaller instance;

    public void marshall(DomainEntry domainEntry, StructuredJsonGenerator jsonGenerator) {
        if (domainEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> optionsMap;
            jsonGenerator.writeStartObject();
            if (domainEntry.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(domainEntry.getId());
            }
            if (domainEntry.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(domainEntry.getName());
            }
            if (domainEntry.getTarget() != null) {
                jsonGenerator.writeFieldName("target").writeValue(domainEntry.getTarget());
            }
            if (domainEntry.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(domainEntry.getType());
            }
            if ((optionsMap = domainEntry.getOptions()) != null) {
                jsonGenerator.writeFieldName("options");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> optionsMapValue : optionsMap.entrySet()) {
                    if (optionsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(optionsMapValue.getKey());
                    jsonGenerator.writeValue(optionsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DomainEntryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DomainEntryJsonMarshaller();
        }
        return instance;
    }
}

