/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.DiskMap;
import com.amazonaws.services.lightsail.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateInstancesFromSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> instanceNames;
    private Map<String, List<DiskMap>> attachedDiskMapping;
    private String availabilityZone;
    private String instanceSnapshotName;
    private String bundleId;
    private String userData;
    private String keyPairName;
    private List<Tag> tags;

    public List<String> getInstanceNames() {
        return this.instanceNames;
    }

    public void setInstanceNames(Collection<String> instanceNames) {
        if (instanceNames == null) {
            this.instanceNames = null;
            return;
        }
        this.instanceNames = new ArrayList<String>(instanceNames);
    }

    public CreateInstancesFromSnapshotRequest withInstanceNames(String ... instanceNames) {
        if (this.instanceNames == null) {
            this.setInstanceNames(new ArrayList<String>(instanceNames.length));
        }
        for (String ele : instanceNames) {
            this.instanceNames.add(ele);
        }
        return this;
    }

    public CreateInstancesFromSnapshotRequest withInstanceNames(Collection<String> instanceNames) {
        this.setInstanceNames(instanceNames);
        return this;
    }

    public Map<String, List<DiskMap>> getAttachedDiskMapping() {
        return this.attachedDiskMapping;
    }

    public void setAttachedDiskMapping(Map<String, List<DiskMap>> attachedDiskMapping) {
        this.attachedDiskMapping = attachedDiskMapping;
    }

    public CreateInstancesFromSnapshotRequest withAttachedDiskMapping(Map<String, List<DiskMap>> attachedDiskMapping) {
        this.setAttachedDiskMapping(attachedDiskMapping);
        return this;
    }

    public CreateInstancesFromSnapshotRequest addAttachedDiskMappingEntry(String key, List<DiskMap> value) {
        if (null == this.attachedDiskMapping) {
            this.attachedDiskMapping = new HashMap<String, List<DiskMap>>();
        }
        if (this.attachedDiskMapping.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attachedDiskMapping.put(key, value);
        return this;
    }

    public CreateInstancesFromSnapshotRequest clearAttachedDiskMappingEntries() {
        this.attachedDiskMapping = null;
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public CreateInstancesFromSnapshotRequest withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setInstanceSnapshotName(String instanceSnapshotName) {
        this.instanceSnapshotName = instanceSnapshotName;
    }

    public String getInstanceSnapshotName() {
        return this.instanceSnapshotName;
    }

    public CreateInstancesFromSnapshotRequest withInstanceSnapshotName(String instanceSnapshotName) {
        this.setInstanceSnapshotName(instanceSnapshotName);
        return this;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public CreateInstancesFromSnapshotRequest withBundleId(String bundleId) {
        this.setBundleId(bundleId);
        return this;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    public CreateInstancesFromSnapshotRequest withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    public void setKeyPairName(String keyPairName) {
        this.keyPairName = keyPairName;
    }

    public String getKeyPairName() {
        return this.keyPairName;
    }

    public CreateInstancesFromSnapshotRequest withKeyPairName(String keyPairName) {
        this.setKeyPairName(keyPairName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateInstancesFromSnapshotRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateInstancesFromSnapshotRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceNames() != null) {
            sb.append("InstanceNames: ").append(this.getInstanceNames()).append(",");
        }
        if (this.getAttachedDiskMapping() != null) {
            sb.append("AttachedDiskMapping: ").append(this.getAttachedDiskMapping()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getInstanceSnapshotName() != null) {
            sb.append("InstanceSnapshotName: ").append(this.getInstanceSnapshotName()).append(",");
        }
        if (this.getBundleId() != null) {
            sb.append("BundleId: ").append(this.getBundleId()).append(",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: ").append(this.getUserData()).append(",");
        }
        if (this.getKeyPairName() != null) {
            sb.append("KeyPairName: ").append(this.getKeyPairName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesFromSnapshotRequest)) {
            return false;
        }
        CreateInstancesFromSnapshotRequest other = (CreateInstancesFromSnapshotRequest)obj;
        if (other.getInstanceNames() == null ^ this.getInstanceNames() == null) {
            return false;
        }
        if (other.getInstanceNames() != null && !other.getInstanceNames().equals(this.getInstanceNames())) {
            return false;
        }
        if (other.getAttachedDiskMapping() == null ^ this.getAttachedDiskMapping() == null) {
            return false;
        }
        if (other.getAttachedDiskMapping() != null && !other.getAttachedDiskMapping().equals(this.getAttachedDiskMapping())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getInstanceSnapshotName() == null ^ this.getInstanceSnapshotName() == null) {
            return false;
        }
        if (other.getInstanceSnapshotName() != null && !other.getInstanceSnapshotName().equals(this.getInstanceSnapshotName())) {
            return false;
        }
        if (other.getBundleId() == null ^ this.getBundleId() == null) {
            return false;
        }
        if (other.getBundleId() != null && !other.getBundleId().equals(this.getBundleId())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getKeyPairName() == null ^ this.getKeyPairName() == null) {
            return false;
        }
        if (other.getKeyPairName() != null && !other.getKeyPairName().equals(this.getKeyPairName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceNames() == null ? 0 : this.getInstanceNames().hashCode());
        hashCode = 31 * hashCode + (this.getAttachedDiskMapping() == null ? 0 : this.getAttachedDiskMapping().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceSnapshotName() == null ? 0 : this.getInstanceSnapshotName().hashCode());
        hashCode = 31 * hashCode + (this.getBundleId() == null ? 0 : this.getBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getKeyPairName() == null ? 0 : this.getKeyPairName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateInstancesFromSnapshotRequest clone() {
        return (CreateInstancesFromSnapshotRequest)super.clone();
    }
}

