/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.DiskSnapshot;
import java.util.Date;

@SdkInternalApi
public class DiskSnapshotMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInGb").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<String> PROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("progress").build();
    private static final MarshallingInfo<String> FROMDISKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromDiskName").build();
    private static final MarshallingInfo<String> FROMDISKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromDiskArn").build();
    private static final DiskSnapshotMarshaller instance = new DiskSnapshotMarshaller();

    public static DiskSnapshotMarshaller getInstance() {
        return instance;
    }

    public void marshall(DiskSnapshot diskSnapshot, ProtocolMarshaller protocolMarshaller) {
        if (diskSnapshot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)diskSnapshot.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getSupportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getSizeInGb(), SIZEINGB_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getProgress(), PROGRESS_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getFromDiskName(), FROMDISKNAME_BINDING);
            protocolMarshaller.marshall((Object)diskSnapshot.getFromDiskArn(), FROMDISKARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

