/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lightsail.model.Bundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetBundlesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Bundle> bundles;
    private String nextPageToken;

    public List<Bundle> getBundles() {
        return this.bundles;
    }

    public void setBundles(Collection<Bundle> bundles) {
        if (bundles == null) {
            this.bundles = null;
            return;
        }
        this.bundles = new ArrayList<Bundle>(bundles);
    }

    public GetBundlesResult withBundles(Bundle ... bundles) {
        if (this.bundles == null) {
            this.setBundles(new ArrayList<Bundle>(bundles.length));
        }
        for (Bundle ele : bundles) {
            this.bundles.add(ele);
        }
        return this;
    }

    public GetBundlesResult withBundles(Collection<Bundle> bundles) {
        this.setBundles(bundles);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetBundlesResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBundles() != null) {
            sb.append("Bundles: ").append(this.getBundles()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBundlesResult)) {
            return false;
        }
        GetBundlesResult other = (GetBundlesResult)obj;
        if (other.getBundles() == null ^ this.getBundles() == null) {
            return false;
        }
        if (other.getBundles() != null && !other.getBundles().equals(this.getBundles())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBundles() == null ? 0 : this.getBundles().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public GetBundlesResult clone() {
        try {
            return (GetBundlesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

