/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanagerusersubscriptions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanagerusersubscriptions.model.transform.SettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Settings
implements Serializable,
Cloneable,
StructuredPojo {
    private String securityGroupId;
    private List<String> subnets;

    public void setSecurityGroupId(String securityGroupId) {
        this.securityGroupId = securityGroupId;
    }

    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    public Settings withSecurityGroupId(String securityGroupId) {
        this.setSecurityGroupId(securityGroupId);
        return this;
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new ArrayList<String>(subnets);
    }

    public Settings withSubnets(String ... subnets) {
        if (this.subnets == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    public Settings withSubnets(Collection<String> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityGroupId() != null) {
            sb.append("SecurityGroupId: ").append(this.getSecurityGroupId()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Settings)) {
            return false;
        }
        Settings other = (Settings)obj;
        if (other.getSecurityGroupId() == null ^ this.getSecurityGroupId() == null) {
            return false;
        }
        if (other.getSecurityGroupId() != null && !other.getSecurityGroupId().equals(this.getSecurityGroupId())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        return other.getSubnets() == null || other.getSubnets().equals(this.getSubnets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityGroupId() == null ? 0 : this.getSecurityGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        return hashCode;
    }

    public Settings clone() {
        try {
            return (Settings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

