/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.licensemanager.model.CheckoutType;
import com.amazonaws.services.licensemanager.model.EntitlementData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckoutLicenseRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String productSKU;
    private String checkoutType;
    private String keyFingerprint;
    private List<EntitlementData> entitlements;
    private String clientToken;
    private String beneficiary;
    private String nodeId;

    public void setProductSKU(String productSKU) {
        this.productSKU = productSKU;
    }

    public String getProductSKU() {
        return this.productSKU;
    }

    public CheckoutLicenseRequest withProductSKU(String productSKU) {
        this.setProductSKU(productSKU);
        return this;
    }

    public void setCheckoutType(String checkoutType) {
        this.checkoutType = checkoutType;
    }

    public String getCheckoutType() {
        return this.checkoutType;
    }

    public CheckoutLicenseRequest withCheckoutType(String checkoutType) {
        this.setCheckoutType(checkoutType);
        return this;
    }

    public CheckoutLicenseRequest withCheckoutType(CheckoutType checkoutType) {
        this.checkoutType = checkoutType.toString();
        return this;
    }

    public void setKeyFingerprint(String keyFingerprint) {
        this.keyFingerprint = keyFingerprint;
    }

    public String getKeyFingerprint() {
        return this.keyFingerprint;
    }

    public CheckoutLicenseRequest withKeyFingerprint(String keyFingerprint) {
        this.setKeyFingerprint(keyFingerprint);
        return this;
    }

    public List<EntitlementData> getEntitlements() {
        return this.entitlements;
    }

    public void setEntitlements(Collection<EntitlementData> entitlements) {
        if (entitlements == null) {
            this.entitlements = null;
            return;
        }
        this.entitlements = new ArrayList<EntitlementData>(entitlements);
    }

    public CheckoutLicenseRequest withEntitlements(EntitlementData ... entitlements) {
        if (this.entitlements == null) {
            this.setEntitlements(new ArrayList<EntitlementData>(entitlements.length));
        }
        for (EntitlementData ele : entitlements) {
            this.entitlements.add(ele);
        }
        return this;
    }

    public CheckoutLicenseRequest withEntitlements(Collection<EntitlementData> entitlements) {
        this.setEntitlements(entitlements);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CheckoutLicenseRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setBeneficiary(String beneficiary) {
        this.beneficiary = beneficiary;
    }

    public String getBeneficiary() {
        return this.beneficiary;
    }

    public CheckoutLicenseRequest withBeneficiary(String beneficiary) {
        this.setBeneficiary(beneficiary);
        return this;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public CheckoutLicenseRequest withNodeId(String nodeId) {
        this.setNodeId(nodeId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProductSKU() != null) {
            sb.append("ProductSKU: ").append(this.getProductSKU()).append(",");
        }
        if (this.getCheckoutType() != null) {
            sb.append("CheckoutType: ").append(this.getCheckoutType()).append(",");
        }
        if (this.getKeyFingerprint() != null) {
            sb.append("KeyFingerprint: ").append(this.getKeyFingerprint()).append(",");
        }
        if (this.getEntitlements() != null) {
            sb.append("Entitlements: ").append(this.getEntitlements()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getBeneficiary() != null) {
            sb.append("Beneficiary: ").append(this.getBeneficiary()).append(",");
        }
        if (this.getNodeId() != null) {
            sb.append("NodeId: ").append(this.getNodeId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutLicenseRequest)) {
            return false;
        }
        CheckoutLicenseRequest other = (CheckoutLicenseRequest)obj;
        if (other.getProductSKU() == null ^ this.getProductSKU() == null) {
            return false;
        }
        if (other.getProductSKU() != null && !other.getProductSKU().equals(this.getProductSKU())) {
            return false;
        }
        if (other.getCheckoutType() == null ^ this.getCheckoutType() == null) {
            return false;
        }
        if (other.getCheckoutType() != null && !other.getCheckoutType().equals(this.getCheckoutType())) {
            return false;
        }
        if (other.getKeyFingerprint() == null ^ this.getKeyFingerprint() == null) {
            return false;
        }
        if (other.getKeyFingerprint() != null && !other.getKeyFingerprint().equals(this.getKeyFingerprint())) {
            return false;
        }
        if (other.getEntitlements() == null ^ this.getEntitlements() == null) {
            return false;
        }
        if (other.getEntitlements() != null && !other.getEntitlements().equals(this.getEntitlements())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getBeneficiary() == null ^ this.getBeneficiary() == null) {
            return false;
        }
        if (other.getBeneficiary() != null && !other.getBeneficiary().equals(this.getBeneficiary())) {
            return false;
        }
        if (other.getNodeId() == null ^ this.getNodeId() == null) {
            return false;
        }
        return other.getNodeId() == null || other.getNodeId().equals(this.getNodeId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProductSKU() == null ? 0 : this.getProductSKU().hashCode());
        hashCode = 31 * hashCode + (this.getCheckoutType() == null ? 0 : this.getCheckoutType().hashCode());
        hashCode = 31 * hashCode + (this.getKeyFingerprint() == null ? 0 : this.getKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.getEntitlements() == null ? 0 : this.getEntitlements().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getBeneficiary() == null ? 0 : this.getBeneficiary().hashCode());
        hashCode = 31 * hashCode + (this.getNodeId() == null ? 0 : this.getNodeId().hashCode());
        return hashCode;
    }

    public CheckoutLicenseRequest clone() {
        return (CheckoutLicenseRequest)super.clone();
    }
}

