/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lexruntimev2.model.Message;
import com.amazonaws.services.lexruntimev2.model.SessionState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PutSessionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String botId;
    private String botAliasId;
    private String localeId;
    private String sessionId;
    private List<Message> messages;
    private SessionState sessionState;
    private Map<String, String> requestAttributes;
    private String responseContentType;

    public void setBotId(String botId) {
        this.botId = botId;
    }

    public String getBotId() {
        return this.botId;
    }

    public PutSessionRequest withBotId(String botId) {
        this.setBotId(botId);
        return this;
    }

    public void setBotAliasId(String botAliasId) {
        this.botAliasId = botAliasId;
    }

    public String getBotAliasId() {
        return this.botAliasId;
    }

    public PutSessionRequest withBotAliasId(String botAliasId) {
        this.setBotAliasId(botAliasId);
        return this;
    }

    public void setLocaleId(String localeId) {
        this.localeId = localeId;
    }

    public String getLocaleId() {
        return this.localeId;
    }

    public PutSessionRequest withLocaleId(String localeId) {
        this.setLocaleId(localeId);
        return this;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public PutSessionRequest withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<Message>(messages);
    }

    public PutSessionRequest withMessages(Message ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<Message>(messages.length));
        }
        for (Message ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public PutSessionRequest withMessages(Collection<Message> messages) {
        this.setMessages(messages);
        return this;
    }

    public void setSessionState(SessionState sessionState) {
        this.sessionState = sessionState;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public PutSessionRequest withSessionState(SessionState sessionState) {
        this.setSessionState(sessionState);
        return this;
    }

    public Map<String, String> getRequestAttributes() {
        return this.requestAttributes;
    }

    public void setRequestAttributes(Map<String, String> requestAttributes) {
        this.requestAttributes = requestAttributes;
    }

    public PutSessionRequest withRequestAttributes(Map<String, String> requestAttributes) {
        this.setRequestAttributes(requestAttributes);
        return this;
    }

    public PutSessionRequest addRequestAttributesEntry(String key, String value) {
        if (null == this.requestAttributes) {
            this.requestAttributes = new HashMap<String, String>();
        }
        if (this.requestAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestAttributes.put(key, value);
        return this;
    }

    public PutSessionRequest clearRequestAttributesEntries() {
        this.requestAttributes = null;
        return this;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public PutSessionRequest withResponseContentType(String responseContentType) {
        this.setResponseContentType(responseContentType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBotId() != null) {
            sb.append("BotId: ").append(this.getBotId()).append(",");
        }
        if (this.getBotAliasId() != null) {
            sb.append("BotAliasId: ").append(this.getBotAliasId()).append(",");
        }
        if (this.getLocaleId() != null) {
            sb.append("LocaleId: ").append(this.getLocaleId()).append(",");
        }
        if (this.getSessionId() != null) {
            sb.append("SessionId: ").append(this.getSessionId()).append(",");
        }
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages()).append(",");
        }
        if (this.getSessionState() != null) {
            sb.append("SessionState: ").append(this.getSessionState()).append(",");
        }
        if (this.getRequestAttributes() != null) {
            sb.append("RequestAttributes: ").append(this.getRequestAttributes()).append(",");
        }
        if (this.getResponseContentType() != null) {
            sb.append("ResponseContentType: ").append(this.getResponseContentType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSessionRequest)) {
            return false;
        }
        PutSessionRequest other = (PutSessionRequest)obj;
        if (other.getBotId() == null ^ this.getBotId() == null) {
            return false;
        }
        if (other.getBotId() != null && !other.getBotId().equals(this.getBotId())) {
            return false;
        }
        if (other.getBotAliasId() == null ^ this.getBotAliasId() == null) {
            return false;
        }
        if (other.getBotAliasId() != null && !other.getBotAliasId().equals(this.getBotAliasId())) {
            return false;
        }
        if (other.getLocaleId() == null ^ this.getLocaleId() == null) {
            return false;
        }
        if (other.getLocaleId() != null && !other.getLocaleId().equals(this.getLocaleId())) {
            return false;
        }
        if (other.getSessionId() == null ^ this.getSessionId() == null) {
            return false;
        }
        if (other.getSessionId() != null && !other.getSessionId().equals(this.getSessionId())) {
            return false;
        }
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        if (other.getMessages() != null && !other.getMessages().equals(this.getMessages())) {
            return false;
        }
        if (other.getSessionState() == null ^ this.getSessionState() == null) {
            return false;
        }
        if (other.getSessionState() != null && !other.getSessionState().equals(this.getSessionState())) {
            return false;
        }
        if (other.getRequestAttributes() == null ^ this.getRequestAttributes() == null) {
            return false;
        }
        if (other.getRequestAttributes() != null && !other.getRequestAttributes().equals(this.getRequestAttributes())) {
            return false;
        }
        if (other.getResponseContentType() == null ^ this.getResponseContentType() == null) {
            return false;
        }
        return other.getResponseContentType() == null || other.getResponseContentType().equals(this.getResponseContentType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBotId() == null ? 0 : this.getBotId().hashCode());
        hashCode = 31 * hashCode + (this.getBotAliasId() == null ? 0 : this.getBotAliasId().hashCode());
        hashCode = 31 * hashCode + (this.getLocaleId() == null ? 0 : this.getLocaleId().hashCode());
        hashCode = 31 * hashCode + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        hashCode = 31 * hashCode + (this.getSessionState() == null ? 0 : this.getSessionState().hashCode());
        hashCode = 31 * hashCode + (this.getRequestAttributes() == null ? 0 : this.getRequestAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getResponseContentType() == null ? 0 : this.getResponseContentType().hashCode());
        return hashCode;
    }

    public PutSessionRequest clone() {
        return (PutSessionRequest)super.clone();
    }
}

