/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntimev2.model.ConfidenceScore;
import com.amazonaws.services.lexruntimev2.model.Intent;
import com.amazonaws.services.lexruntimev2.model.InterpretationSource;
import com.amazonaws.services.lexruntimev2.model.SentimentResponse;
import com.amazonaws.services.lexruntimev2.model.transform.InterpretationMarshaller;
import java.io.Serializable;

public class Interpretation
implements Serializable,
Cloneable,
StructuredPojo {
    private ConfidenceScore nluConfidence;
    private SentimentResponse sentimentResponse;
    private Intent intent;
    private String interpretationSource;

    public void setNluConfidence(ConfidenceScore nluConfidence) {
        this.nluConfidence = nluConfidence;
    }

    public ConfidenceScore getNluConfidence() {
        return this.nluConfidence;
    }

    public Interpretation withNluConfidence(ConfidenceScore nluConfidence) {
        this.setNluConfidence(nluConfidence);
        return this;
    }

    public void setSentimentResponse(SentimentResponse sentimentResponse) {
        this.sentimentResponse = sentimentResponse;
    }

    public SentimentResponse getSentimentResponse() {
        return this.sentimentResponse;
    }

    public Interpretation withSentimentResponse(SentimentResponse sentimentResponse) {
        this.setSentimentResponse(sentimentResponse);
        return this;
    }

    public void setIntent(Intent intent) {
        this.intent = intent;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public Interpretation withIntent(Intent intent) {
        this.setIntent(intent);
        return this;
    }

    public void setInterpretationSource(String interpretationSource) {
        this.interpretationSource = interpretationSource;
    }

    public String getInterpretationSource() {
        return this.interpretationSource;
    }

    public Interpretation withInterpretationSource(String interpretationSource) {
        this.setInterpretationSource(interpretationSource);
        return this;
    }

    public Interpretation withInterpretationSource(InterpretationSource interpretationSource) {
        this.interpretationSource = interpretationSource.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNluConfidence() != null) {
            sb.append("NluConfidence: ").append(this.getNluConfidence()).append(",");
        }
        if (this.getSentimentResponse() != null) {
            sb.append("SentimentResponse: ").append(this.getSentimentResponse()).append(",");
        }
        if (this.getIntent() != null) {
            sb.append("Intent: ").append(this.getIntent()).append(",");
        }
        if (this.getInterpretationSource() != null) {
            sb.append("InterpretationSource: ").append(this.getInterpretationSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interpretation)) {
            return false;
        }
        Interpretation other = (Interpretation)obj;
        if (other.getNluConfidence() == null ^ this.getNluConfidence() == null) {
            return false;
        }
        if (other.getNluConfidence() != null && !other.getNluConfidence().equals(this.getNluConfidence())) {
            return false;
        }
        if (other.getSentimentResponse() == null ^ this.getSentimentResponse() == null) {
            return false;
        }
        if (other.getSentimentResponse() != null && !other.getSentimentResponse().equals(this.getSentimentResponse())) {
            return false;
        }
        if (other.getIntent() == null ^ this.getIntent() == null) {
            return false;
        }
        if (other.getIntent() != null && !other.getIntent().equals(this.getIntent())) {
            return false;
        }
        if (other.getInterpretationSource() == null ^ this.getInterpretationSource() == null) {
            return false;
        }
        return other.getInterpretationSource() == null || other.getInterpretationSource().equals(this.getInterpretationSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNluConfidence() == null ? 0 : this.getNluConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getSentimentResponse() == null ? 0 : this.getSentimentResponse().hashCode());
        hashCode = 31 * hashCode + (this.getIntent() == null ? 0 : this.getIntent().hashCode());
        hashCode = 31 * hashCode + (this.getInterpretationSource() == null ? 0 : this.getInterpretationSource().hashCode());
        return hashCode;
    }

    public Interpretation clone() {
        try {
            return (Interpretation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InterpretationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

