/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.ActiveContext;
import com.amazonaws.services.lexmodelsv2.model.RuntimeHints;
import com.amazonaws.services.lexmodelsv2.model.transform.InputSessionStateSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputSessionStateSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> sessionAttributes;
    private List<ActiveContext> activeContexts;
    private RuntimeHints runtimeHints;

    public Map<String, String> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public InputSessionStateSpecification withSessionAttributes(Map<String, String> sessionAttributes) {
        this.setSessionAttributes(sessionAttributes);
        return this;
    }

    public InputSessionStateSpecification addSessionAttributesEntry(String key, String value) {
        if (null == this.sessionAttributes) {
            this.sessionAttributes = new HashMap<String, String>();
        }
        if (this.sessionAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sessionAttributes.put(key, value);
        return this;
    }

    public InputSessionStateSpecification clearSessionAttributesEntries() {
        this.sessionAttributes = null;
        return this;
    }

    public List<ActiveContext> getActiveContexts() {
        return this.activeContexts;
    }

    public void setActiveContexts(Collection<ActiveContext> activeContexts) {
        if (activeContexts == null) {
            this.activeContexts = null;
            return;
        }
        this.activeContexts = new ArrayList<ActiveContext>(activeContexts);
    }

    public InputSessionStateSpecification withActiveContexts(ActiveContext ... activeContexts) {
        if (this.activeContexts == null) {
            this.setActiveContexts(new ArrayList<ActiveContext>(activeContexts.length));
        }
        for (ActiveContext ele : activeContexts) {
            this.activeContexts.add(ele);
        }
        return this;
    }

    public InputSessionStateSpecification withActiveContexts(Collection<ActiveContext> activeContexts) {
        this.setActiveContexts(activeContexts);
        return this;
    }

    public void setRuntimeHints(RuntimeHints runtimeHints) {
        this.runtimeHints = runtimeHints;
    }

    public RuntimeHints getRuntimeHints() {
        return this.runtimeHints;
    }

    public InputSessionStateSpecification withRuntimeHints(RuntimeHints runtimeHints) {
        this.setRuntimeHints(runtimeHints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSessionAttributes() != null) {
            sb.append("SessionAttributes: ").append(this.getSessionAttributes()).append(",");
        }
        if (this.getActiveContexts() != null) {
            sb.append("ActiveContexts: ").append(this.getActiveContexts()).append(",");
        }
        if (this.getRuntimeHints() != null) {
            sb.append("RuntimeHints: ").append(this.getRuntimeHints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSessionStateSpecification)) {
            return false;
        }
        InputSessionStateSpecification other = (InputSessionStateSpecification)obj;
        if (other.getSessionAttributes() == null ^ this.getSessionAttributes() == null) {
            return false;
        }
        if (other.getSessionAttributes() != null && !other.getSessionAttributes().equals(this.getSessionAttributes())) {
            return false;
        }
        if (other.getActiveContexts() == null ^ this.getActiveContexts() == null) {
            return false;
        }
        if (other.getActiveContexts() != null && !other.getActiveContexts().equals(this.getActiveContexts())) {
            return false;
        }
        if (other.getRuntimeHints() == null ^ this.getRuntimeHints() == null) {
            return false;
        }
        return other.getRuntimeHints() == null || other.getRuntimeHints().equals(this.getRuntimeHints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSessionAttributes() == null ? 0 : this.getSessionAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getActiveContexts() == null ? 0 : this.getActiveContexts().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimeHints() == null ? 0 : this.getRuntimeHints().hashCode());
        return hashCode;
    }

    public InputSessionStateSpecification clone() {
        try {
            return (InputSessionStateSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSessionStateSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

