/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelbuilding.model.ObfuscationSetting;
import com.amazonaws.services.lexmodelbuilding.model.Prompt;
import com.amazonaws.services.lexmodelbuilding.model.SlotConstraint;
import com.amazonaws.services.lexmodelbuilding.model.SlotDefaultValueSpec;
import com.amazonaws.services.lexmodelbuilding.model.transform.SlotMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Slot
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String slotConstraint;
    private String slotType;
    private String slotTypeVersion;
    private Prompt valueElicitationPrompt;
    private Integer priority;
    private List<String> sampleUtterances;
    private String responseCard;
    private String obfuscationSetting;
    private SlotDefaultValueSpec defaultValueSpec;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Slot withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Slot withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSlotConstraint(String slotConstraint) {
        this.slotConstraint = slotConstraint;
    }

    public String getSlotConstraint() {
        return this.slotConstraint;
    }

    public Slot withSlotConstraint(String slotConstraint) {
        this.setSlotConstraint(slotConstraint);
        return this;
    }

    public void setSlotConstraint(SlotConstraint slotConstraint) {
        this.withSlotConstraint(slotConstraint);
    }

    public Slot withSlotConstraint(SlotConstraint slotConstraint) {
        this.slotConstraint = slotConstraint.toString();
        return this;
    }

    public void setSlotType(String slotType) {
        this.slotType = slotType;
    }

    public String getSlotType() {
        return this.slotType;
    }

    public Slot withSlotType(String slotType) {
        this.setSlotType(slotType);
        return this;
    }

    public void setSlotTypeVersion(String slotTypeVersion) {
        this.slotTypeVersion = slotTypeVersion;
    }

    public String getSlotTypeVersion() {
        return this.slotTypeVersion;
    }

    public Slot withSlotTypeVersion(String slotTypeVersion) {
        this.setSlotTypeVersion(slotTypeVersion);
        return this;
    }

    public void setValueElicitationPrompt(Prompt valueElicitationPrompt) {
        this.valueElicitationPrompt = valueElicitationPrompt;
    }

    public Prompt getValueElicitationPrompt() {
        return this.valueElicitationPrompt;
    }

    public Slot withValueElicitationPrompt(Prompt valueElicitationPrompt) {
        this.setValueElicitationPrompt(valueElicitationPrompt);
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Slot withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public List<String> getSampleUtterances() {
        return this.sampleUtterances;
    }

    public void setSampleUtterances(Collection<String> sampleUtterances) {
        if (sampleUtterances == null) {
            this.sampleUtterances = null;
            return;
        }
        this.sampleUtterances = new ArrayList<String>(sampleUtterances);
    }

    public Slot withSampleUtterances(String ... sampleUtterances) {
        if (this.sampleUtterances == null) {
            this.setSampleUtterances(new ArrayList<String>(sampleUtterances.length));
        }
        for (String ele : sampleUtterances) {
            this.sampleUtterances.add(ele);
        }
        return this;
    }

    public Slot withSampleUtterances(Collection<String> sampleUtterances) {
        this.setSampleUtterances(sampleUtterances);
        return this;
    }

    public void setResponseCard(String responseCard) {
        this.responseCard = responseCard;
    }

    public String getResponseCard() {
        return this.responseCard;
    }

    public Slot withResponseCard(String responseCard) {
        this.setResponseCard(responseCard);
        return this;
    }

    public void setObfuscationSetting(String obfuscationSetting) {
        this.obfuscationSetting = obfuscationSetting;
    }

    public String getObfuscationSetting() {
        return this.obfuscationSetting;
    }

    public Slot withObfuscationSetting(String obfuscationSetting) {
        this.setObfuscationSetting(obfuscationSetting);
        return this;
    }

    public void setObfuscationSetting(ObfuscationSetting obfuscationSetting) {
        this.withObfuscationSetting(obfuscationSetting);
    }

    public Slot withObfuscationSetting(ObfuscationSetting obfuscationSetting) {
        this.obfuscationSetting = obfuscationSetting.toString();
        return this;
    }

    public void setDefaultValueSpec(SlotDefaultValueSpec defaultValueSpec) {
        this.defaultValueSpec = defaultValueSpec;
    }

    public SlotDefaultValueSpec getDefaultValueSpec() {
        return this.defaultValueSpec;
    }

    public Slot withDefaultValueSpec(SlotDefaultValueSpec defaultValueSpec) {
        this.setDefaultValueSpec(defaultValueSpec);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSlotConstraint() != null) {
            sb.append("SlotConstraint: ").append(this.getSlotConstraint()).append(",");
        }
        if (this.getSlotType() != null) {
            sb.append("SlotType: ").append(this.getSlotType()).append(",");
        }
        if (this.getSlotTypeVersion() != null) {
            sb.append("SlotTypeVersion: ").append(this.getSlotTypeVersion()).append(",");
        }
        if (this.getValueElicitationPrompt() != null) {
            sb.append("ValueElicitationPrompt: ").append(this.getValueElicitationPrompt()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority()).append(",");
        }
        if (this.getSampleUtterances() != null) {
            sb.append("SampleUtterances: ").append(this.getSampleUtterances()).append(",");
        }
        if (this.getResponseCard() != null) {
            sb.append("ResponseCard: ").append(this.getResponseCard()).append(",");
        }
        if (this.getObfuscationSetting() != null) {
            sb.append("ObfuscationSetting: ").append(this.getObfuscationSetting()).append(",");
        }
        if (this.getDefaultValueSpec() != null) {
            sb.append("DefaultValueSpec: ").append(this.getDefaultValueSpec());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSlotConstraint() == null ^ this.getSlotConstraint() == null) {
            return false;
        }
        if (other.getSlotConstraint() != null && !other.getSlotConstraint().equals(this.getSlotConstraint())) {
            return false;
        }
        if (other.getSlotType() == null ^ this.getSlotType() == null) {
            return false;
        }
        if (other.getSlotType() != null && !other.getSlotType().equals(this.getSlotType())) {
            return false;
        }
        if (other.getSlotTypeVersion() == null ^ this.getSlotTypeVersion() == null) {
            return false;
        }
        if (other.getSlotTypeVersion() != null && !other.getSlotTypeVersion().equals(this.getSlotTypeVersion())) {
            return false;
        }
        if (other.getValueElicitationPrompt() == null ^ this.getValueElicitationPrompt() == null) {
            return false;
        }
        if (other.getValueElicitationPrompt() != null && !other.getValueElicitationPrompt().equals(this.getValueElicitationPrompt())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getSampleUtterances() == null ^ this.getSampleUtterances() == null) {
            return false;
        }
        if (other.getSampleUtterances() != null && !other.getSampleUtterances().equals(this.getSampleUtterances())) {
            return false;
        }
        if (other.getResponseCard() == null ^ this.getResponseCard() == null) {
            return false;
        }
        if (other.getResponseCard() != null && !other.getResponseCard().equals(this.getResponseCard())) {
            return false;
        }
        if (other.getObfuscationSetting() == null ^ this.getObfuscationSetting() == null) {
            return false;
        }
        if (other.getObfuscationSetting() != null && !other.getObfuscationSetting().equals(this.getObfuscationSetting())) {
            return false;
        }
        if (other.getDefaultValueSpec() == null ^ this.getDefaultValueSpec() == null) {
            return false;
        }
        return other.getDefaultValueSpec() == null || other.getDefaultValueSpec().equals(this.getDefaultValueSpec());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSlotConstraint() == null ? 0 : this.getSlotConstraint().hashCode());
        hashCode = 31 * hashCode + (this.getSlotType() == null ? 0 : this.getSlotType().hashCode());
        hashCode = 31 * hashCode + (this.getSlotTypeVersion() == null ? 0 : this.getSlotTypeVersion().hashCode());
        hashCode = 31 * hashCode + (this.getValueElicitationPrompt() == null ? 0 : this.getValueElicitationPrompt().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getSampleUtterances() == null ? 0 : this.getSampleUtterances().hashCode());
        hashCode = 31 * hashCode + (this.getResponseCard() == null ? 0 : this.getResponseCard().hashCode());
        hashCode = 31 * hashCode + (this.getObfuscationSetting() == null ? 0 : this.getObfuscationSetting().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValueSpec() == null ? 0 : this.getDefaultValueSpec().hashCode());
        return hashCode;
    }

    public Slot clone() {
        try {
            return (Slot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SlotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

