/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelbuilding.model.transform.EnumerationValueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnumerationValue
implements Serializable,
Cloneable,
StructuredPojo {
    private String value;
    private List<String> synonyms;

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public EnumerationValue withValue(String value) {
        this.setValue(value);
        return this;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Collection<String> synonyms) {
        if (synonyms == null) {
            this.synonyms = null;
            return;
        }
        this.synonyms = new ArrayList<String>(synonyms);
    }

    public EnumerationValue withSynonyms(String ... synonyms) {
        if (this.synonyms == null) {
            this.setSynonyms(new ArrayList<String>(synonyms.length));
        }
        for (String ele : synonyms) {
            this.synonyms.add(ele);
        }
        return this;
    }

    public EnumerationValue withSynonyms(Collection<String> synonyms) {
        this.setSynonyms(synonyms);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getSynonyms() != null) {
            sb.append("Synonyms: ").append(this.getSynonyms());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumerationValue)) {
            return false;
        }
        EnumerationValue other = (EnumerationValue)obj;
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getSynonyms() == null ^ this.getSynonyms() == null) {
            return false;
        }
        return other.getSynonyms() == null || other.getSynonyms().equals(this.getSynonyms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getSynonyms() == null ? 0 : this.getSynonyms().hashCode());
        return hashCode;
    }

    public EnumerationValue clone() {
        try {
            return (EnumerationValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnumerationValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

