/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lexruntime.model.Button;
import com.amazonaws.services.lexruntime.model.GenericAttachment;
import com.amazonaws.services.lexruntime.model.transform.ButtonJsonMarshaller;
import java.util.List;

public class GenericAttachmentJsonMarshaller {
    private static GenericAttachmentJsonMarshaller instance;

    public void marshall(GenericAttachment genericAttachment, StructuredJsonGenerator jsonGenerator) {
        if (genericAttachment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Button> buttonsList;
            jsonGenerator.writeStartObject();
            if (genericAttachment.getTitle() != null) {
                jsonGenerator.writeFieldName("title").writeValue(genericAttachment.getTitle());
            }
            if (genericAttachment.getSubTitle() != null) {
                jsonGenerator.writeFieldName("subTitle").writeValue(genericAttachment.getSubTitle());
            }
            if (genericAttachment.getAttachmentLinkUrl() != null) {
                jsonGenerator.writeFieldName("attachmentLinkUrl").writeValue(genericAttachment.getAttachmentLinkUrl());
            }
            if (genericAttachment.getImageUrl() != null) {
                jsonGenerator.writeFieldName("imageUrl").writeValue(genericAttachment.getImageUrl());
            }
            if ((buttonsList = genericAttachment.getButtons()) != null) {
                jsonGenerator.writeFieldName("buttons");
                jsonGenerator.writeStartArray();
                for (Button buttonsListValue : buttonsList) {
                    if (buttonsListValue == null) continue;
                    ButtonJsonMarshaller.getInstance().marshall(buttonsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GenericAttachmentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GenericAttachmentJsonMarshaller();
        }
        return instance;
    }
}

