/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lexruntime.model.GenericAttachment;
import com.amazonaws.services.lexruntime.model.ResponseCard;
import com.amazonaws.services.lexruntime.model.transform.GenericAttachmentJsonMarshaller;
import java.util.List;

public class ResponseCardJsonMarshaller {
    private static ResponseCardJsonMarshaller instance;

    public void marshall(ResponseCard responseCard, StructuredJsonGenerator jsonGenerator) {
        if (responseCard == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<GenericAttachment> genericAttachmentsList;
            jsonGenerator.writeStartObject();
            if (responseCard.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(responseCard.getVersion());
            }
            if (responseCard.getContentType() != null) {
                jsonGenerator.writeFieldName("contentType").writeValue(responseCard.getContentType());
            }
            if ((genericAttachmentsList = responseCard.getGenericAttachments()) != null) {
                jsonGenerator.writeFieldName("genericAttachments");
                jsonGenerator.writeStartArray();
                for (GenericAttachment genericAttachmentsListValue : genericAttachmentsList) {
                    if (genericAttachmentsListValue == null) continue;
                    GenericAttachmentJsonMarshaller.getInstance().marshall(genericAttachmentsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResponseCardJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResponseCardJsonMarshaller();
        }
        return instance;
    }
}

