/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lexruntime.model.DialogAction;
import com.amazonaws.services.lexruntime.model.IntentSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PutSessionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String botName;
    private String botAlias;
    private String userId;
    private Map<String, String> sessionAttributes;
    private DialogAction dialogAction;
    private List<IntentSummary> recentIntentSummaryView;
    private String accept;

    public void setBotName(String botName) {
        this.botName = botName;
    }

    public String getBotName() {
        return this.botName;
    }

    public PutSessionRequest withBotName(String botName) {
        this.setBotName(botName);
        return this;
    }

    public void setBotAlias(String botAlias) {
        this.botAlias = botAlias;
    }

    public String getBotAlias() {
        return this.botAlias;
    }

    public PutSessionRequest withBotAlias(String botAlias) {
        this.setBotAlias(botAlias);
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public PutSessionRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public Map<String, String> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public PutSessionRequest withSessionAttributes(Map<String, String> sessionAttributes) {
        this.setSessionAttributes(sessionAttributes);
        return this;
    }

    public PutSessionRequest addSessionAttributesEntry(String key, String value) {
        if (null == this.sessionAttributes) {
            this.sessionAttributes = new HashMap<String, String>();
        }
        if (this.sessionAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sessionAttributes.put(key, value);
        return this;
    }

    public PutSessionRequest clearSessionAttributesEntries() {
        this.sessionAttributes = null;
        return this;
    }

    public void setDialogAction(DialogAction dialogAction) {
        this.dialogAction = dialogAction;
    }

    public DialogAction getDialogAction() {
        return this.dialogAction;
    }

    public PutSessionRequest withDialogAction(DialogAction dialogAction) {
        this.setDialogAction(dialogAction);
        return this;
    }

    public List<IntentSummary> getRecentIntentSummaryView() {
        return this.recentIntentSummaryView;
    }

    public void setRecentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView) {
        if (recentIntentSummaryView == null) {
            this.recentIntentSummaryView = null;
            return;
        }
        this.recentIntentSummaryView = new ArrayList<IntentSummary>(recentIntentSummaryView);
    }

    public PutSessionRequest withRecentIntentSummaryView(IntentSummary ... recentIntentSummaryView) {
        if (this.recentIntentSummaryView == null) {
            this.setRecentIntentSummaryView(new ArrayList<IntentSummary>(recentIntentSummaryView.length));
        }
        for (IntentSummary ele : recentIntentSummaryView) {
            this.recentIntentSummaryView.add(ele);
        }
        return this;
    }

    public PutSessionRequest withRecentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView) {
        this.setRecentIntentSummaryView(recentIntentSummaryView);
        return this;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getAccept() {
        return this.accept;
    }

    public PutSessionRequest withAccept(String accept) {
        this.setAccept(accept);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBotName() != null) {
            sb.append("BotName: ").append(this.getBotName()).append(",");
        }
        if (this.getBotAlias() != null) {
            sb.append("BotAlias: ").append(this.getBotAlias()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId()).append(",");
        }
        if (this.getSessionAttributes() != null) {
            sb.append("SessionAttributes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDialogAction() != null) {
            sb.append("DialogAction: ").append(this.getDialogAction()).append(",");
        }
        if (this.getRecentIntentSummaryView() != null) {
            sb.append("RecentIntentSummaryView: ").append(this.getRecentIntentSummaryView()).append(",");
        }
        if (this.getAccept() != null) {
            sb.append("Accept: ").append(this.getAccept());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSessionRequest)) {
            return false;
        }
        PutSessionRequest other = (PutSessionRequest)obj;
        if (other.getBotName() == null ^ this.getBotName() == null) {
            return false;
        }
        if (other.getBotName() != null && !other.getBotName().equals(this.getBotName())) {
            return false;
        }
        if (other.getBotAlias() == null ^ this.getBotAlias() == null) {
            return false;
        }
        if (other.getBotAlias() != null && !other.getBotAlias().equals(this.getBotAlias())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        if (other.getUserId() != null && !other.getUserId().equals(this.getUserId())) {
            return false;
        }
        if (other.getSessionAttributes() == null ^ this.getSessionAttributes() == null) {
            return false;
        }
        if (other.getSessionAttributes() != null && !other.getSessionAttributes().equals(this.getSessionAttributes())) {
            return false;
        }
        if (other.getDialogAction() == null ^ this.getDialogAction() == null) {
            return false;
        }
        if (other.getDialogAction() != null && !other.getDialogAction().equals(this.getDialogAction())) {
            return false;
        }
        if (other.getRecentIntentSummaryView() == null ^ this.getRecentIntentSummaryView() == null) {
            return false;
        }
        if (other.getRecentIntentSummaryView() != null && !other.getRecentIntentSummaryView().equals(this.getRecentIntentSummaryView())) {
            return false;
        }
        if (other.getAccept() == null ^ this.getAccept() == null) {
            return false;
        }
        return other.getAccept() == null || other.getAccept().equals(this.getAccept());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBotName() == null ? 0 : this.getBotName().hashCode());
        hashCode = 31 * hashCode + (this.getBotAlias() == null ? 0 : this.getBotAlias().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        hashCode = 31 * hashCode + (this.getSessionAttributes() == null ? 0 : this.getSessionAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getDialogAction() == null ? 0 : this.getDialogAction().hashCode());
        hashCode = 31 * hashCode + (this.getRecentIntentSummaryView() == null ? 0 : this.getRecentIntentSummaryView().hashCode());
        hashCode = 31 * hashCode + (this.getAccept() == null ? 0 : this.getAccept().hashCode());
        return hashCode;
    }

    public PutSessionRequest clone() {
        return (PutSessionRequest)super.clone();
    }
}

